//
// lassheetitem.cpp
//
// Copyright 2015 by John Pietrzak (jpietrzak8@gmail.com)
//
// This file is part of Lasagne.
//
// Lasagne is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// Lasagne is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Lasagne; if not, write to the Free Software Foundation,
// Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
//

#include "lassheetitem.h"
#include "lassheet.h"
#include "lasroles.h"

#include <QDebug>

LasSheetItem::LasSheetItem()
  : QTableWidgetItem(),
    isResolving(false),
    parentSheet(0)
{
}


LasSheetItem::LasSheetItem(
  QString text,
  LasSheet *ls)
  : QTableWidgetItem(text),
    isResolving(false),
    parentSheet(ls)
{
  setData(LAS_FORMULAROLE, text);
}


QTableWidgetItem *LasSheetItem::clone() const
{
  LasSheetItem *item = new LasSheetItem();
  *item = *this;
  return item;
}


void LasSheetItem::setParent(
  LasSheet *ls)
{
  parentSheet = ls;
}


void LasSheetItem::setData(
  int role,
  const QVariant &value)
{
  if (role == LAS_FORMULAROLE)
  {
    formula = value.toString();
  }
  else
  {
    QTableWidgetItem::setData(role, value);
  }
}


QVariant LasSheetItem::data(
  int role) const
{
  if (role == LAS_FORMULAROLE)
  {
    return formula;
  }

  if (role == Qt::DisplayRole)
  {
    return display().toString();
  }

  // For now, text color and text alignment will be fixed:
  if (role == Qt::TextColorRole)
  {
    if (row() == 0)
    {
      return parentSheet->getColor(Title_Color);
    }
    else
    {
      return parentSheet->getColor(Text_Color);
    }
  }

/*
  QString t = display().toString();
  bool isNumber = false;
  int number = t.toInt(&isNumber);

  if (role == Qt::TextColorRole)
  {
    // Sanity check:
    if (!parentSheet) return QVariant(); 

    // Different color for title row:
    if (row() == 0)
    {
      return parentSheet->getTitleColor();
    }

    if (!isNumber)
    {
      return parentSheet->getColor(Text_Color);
//      return QVariant::fromValue(QColor(Qt::black));
    }
    else if (number < 0)
    {
      return QVariant::fromValue(QColor(Qt::red));
    }
    else
    {
      return QVariant::fromValue(QColor(Qt::blue));
    }
  }

  if (role == Qt::TextAlignmentRole)
  {
    if (!t.isEmpty() && (t.at(0).isNumber() || t.at(0) == '-'))
    {
      return (int)(Qt::AlignRight | Qt::AlignVCenter);
    }
  }
*/

  return QTableWidgetItem::data(role);
}


QVariant LasSheetItem::display() const
{
  if (isResolving || !parentSheet)
  {
//qDebug() << "isResolving: " << isResolving;
//if (!parentSheet) qDebug() << "parentSheet is null";
    return QVariant(); // To deal with circular reference
  }

  isResolving = true;
  QVariant result = parentSheet->computeFormula(this);
  isResolving = false;
  return result;
}

