#ifndef VIEWER_H
#define VIEWER_H

#include <QtGui/QMainWindow>
#include <QWidget>
#include <QVBoxLayout>
#include <QMenuBar>
#include <QMenu>
#include <QAction>
#include <QToolBar>
#include <QToolButton>
#include <QIcon>
#include <QFileDialog>
#include <QMessageBox>
#include <QLabel>
#include <QScrollArea>
#include <QImage>
#include <QPixmap>
#include <QStackedWidget>
#include <QPushButton>
#include <QStringList>
#include <QSound>
#include <QFileInfo>
#include <QSettings>


#include "editwidget.h"
#include "history.h"

class Viewer : public QMainWindow
{
	Q_OBJECT

public:
	Viewer(QWidget *parent = 0, Qt::WFlags flags = 0);
	~Viewer();
	void initToolBar();
	void initMenu();
	void initEditToolBar();///
	void initStatusBar();
	void editViewer();///
	void initViewer();
	void ScaleImage(double factor);
	void initEditor();
	void showViewer(int imageNumber);
	void showStatusMessage(QString message);
	void fitImageToLayout();
	void getConfig(QSettings *cfg);
	int currentImageNumber;

private:
	//Ui::ViewerClass ui;
	double scaleFactor;
	double editScaleFactor;
    QAction *act22;
	QSettings *cfg;

	QStatusBar *statusBar;
	//statusbar
	QLabel *statusMessage;
	QLabel *sizeStatusString;
	QLabel *resolutionStatusString;

	QLabel *imageLabel;
	QAction *actCounter;
	QAction *actZoomIn;
	QAction *actZoomOut;
	QScrollArea *scrollArea;
	QStackedWidget *widgetSet;
	QStringList imageFileNames;
	QAction *actPen;///
	QAction *actCrop;///
	EditWidget *editImageLabel;///
	
	//History *pixmapHistory;

	QVBoxLayout *vbl;
	QToolBar *mainToolBar;
	QToolBar *editToolBar;
	QToolBar *editToolBar2;
	void Error(QString err);
	void showMessage(QString message);
	void resizeEvent(QResizeEvent* event);

public slots:
	void LoadImages();
	void SaveImage();
	void About();
    void Resize();
	
	void showPreviousImage();
	void showNextImage();
	void showEditor();
	void zoomIn();
	void zoomOut();
	void fitToScreen();
	void drawPen();///
    void drawSelect();///
    void drawCrop();///
	void currentIndexChanged(int index);///
	void chooseColor();///

};

#endif // VIEWER_H
 
