using GLib;
using Gtk;
using Pango;

public class Item : Gtk.Fixed
{
	Knots knots;
	HashTable<string,string> fields;
	Gtk.Label label;
	string text;
	int item_type;
	public static int CATEGORY = 0;
	public static int TAG = 1;
	public static int VALUE = 2;
	public static int ITEM = 3;
	public static int DIR = 4;
	public static int VIRTUAL = 5;
	public static int SERVER = 6;
	public static int BUTTON = 7;
	EventBox eb;
	Gtk.Image image;
	private bool icon_view;
	private bool clicked;
	Gdk.Pixbuf default_image;
	private bool grabbing;
	
	public Item(Knots knots, HashTable fields, bool icon_view) {
		this.knots = knots;
		this.fields = fields;
		this.grabbing = false;
		this.icon_view = icon_view;
		init_widget();
	}
	
	public void set_clicked(bool clicked)
	{
		this.clicked = clicked;
	}
	
	public bool was_clicked()
	{
		return this.clicked;
	}
	
	public bool has_icon_view()
	{
		return this.icon_view;
	}
	
	public void init_widget()
	{
		string[] types = {"category", "tag", "value", "name", "dirname", "virtual", "server", "button"};
		for (int i = 0; i < types.length; i++)
		{
			if (fields.lookup(types[types.length - 1 - i]) != null)
			{
				text = (string)fields.lookup(types[types.length - 1 - i]);
				item_type = types.length - 1 - i;
				break;
			}
		}
		image = new Gtk.Image();
		load_image();
	}
	
	public string entity_escape(string str)
	{
		if (str != null)
			return str.replace("&", "&amp;").replace("'", "&apos;").replace("\"", "&quot;").replace(">", "&gt;").replace("<", "&lt;");
		return str;
	}
	
	public void create()
	{
		this.width_request = width();
		this.height_request = height();
		if (icon_view)
		{
			if (text.len() > 25)
				text = text.substring(0, 25);
			eb = new EventBox();
			eb.width_request = 160;
			eb.height_request = 125;
			this.put(eb, 0, 0);
			label = new Label(get_item_label());
			label.set_justify(Gtk.Justification.CENTER);
			label.height_request = 15;
			label.width_request = 140;
			this.put(label, 10, 135);
			Pango.FontDescription f = label.get_pango_context().get_font_description();
			f.set_size(1024 * 10);
			label.modify_font(f);
			image.width_request = 140;
			image.height_request = 105;
			eb.add(image);
		}
		else
		{
			eb = new EventBox();
			eb.width_request = width() - height();
			eb.height_request = height();
			this.put(eb, height(), 0);
			label = new Label("");
			label.set_alignment(0,(float)0.5);
			label.set_ellipsize(Pango.EllipsizeMode.END);
			label.set_markup(get_item_label());
			Pango.FontDescription f = label.get_pango_context().get_font_description();
			f.set_size(1024 * 12);
			label.modify_font(f);
			eb.add(label);
			image.width_request = 64;
			image.height_request = 64;
			eb.set_border_width(1);
			this.put(image, 8,8);
		}
	}
	
	public void new_width(int width)
	{
		if (!icon_view)
			eb.width_request = width - height();			
		this.width_request = width;
	}
	
	
	public string get_item_attribute(string key)
	{
		return (string)fields.lookup(key);
	}
	
	public int get_item_type()
	{
		return item_type;
	}
	
	public string get_item_label()
	{
		return (icon_view ? text : entity_escape(text));
	}
	
	public int get_item_id()
	{
		return get_item_attribute("id").to_int();
	}
	
	public string get_plot()
	{
		return get_item_attribute("info");
	}
	
	public Gtk.Image get_image()
	{
		return image;
	}
	
	public bool item_selected(Gdk.EventButton? eb, long press_seconds)
	{
		if (get_item_type() == BUTTON)
		{
			highlight();
			this.queue_draw();
			if (get_item_id() == 1)
				knots.connect_server_automatically();
			else
			if (get_item_id() == 2)
				knots.connect_server_manually();
		}
		else
		if (get_item_type() == SERVER)
		{
			highlight();
			this.queue_draw();
			knots.get_connection().select_server(get_item_id());
			knots.connect_server();
		}
		else
		if (get_item_type() == DIR)
		{
			highlight();
			this.queue_draw();
			knots.get_browser().browse_by_path(get_item_attribute("dir"), false);
		}
		else
		if (get_item_type() == VIRTUAL)
		{
			highlight();
			this.queue_draw();
			knots.get_browser().show_virtual_category(get_item_attribute("search"), 1);
		}
		else
		if (get_item_type() != ITEM)
		{
			highlight();
			knots.get_browser().browsepaths[get_item_type()] = get_item_id();
			knots.get_browser().pages[get_item_type()] = 1;
			this.queue_draw();
			knots.get_browser().browse();
		}
		else
		{
			knots.get_info().show_info(this);
		}
		return false;
	}
	
	public bool refetch_screenshot()
	{
		if (!grabbing && this.icon_view && get_item_attribute("mediatype") != "8")
		{
			knots.alert("Grabbing new image");
			grabbing = true;
			try
			{
				Thread.create(refetch_new_screenshot, true);
			}
			catch (ThreadError e)
			{
			}
		}
		return false;
	}
	
	public void* refetch_new_screenshot()
	{
		if (get_item_attribute("mid") != null)
			knots.get_common().clear_image(get_item_attribute("mid"));
		knots.get_connection().set_url_cache(false);
		string? mid = knots.get_connection().fetch("/external/refetch_screenshot?id=" + get_item_id().to_string());
		if (mid != null && mid != "")
		{
			fields.insert("mid", mid.strip());
			GLib.Idle.add(load_image);
			knots.get_common().clear_cache(1);
		}
		grabbing = false;
		return null;
	}
	
	public void highlight()
	{
		label.set_markup("<u>" + get_item_label() + "</u>");
	}
	
	public void lowlight()
	{
		label.set_markup(get_item_label());
	}
	
	public bool load_image()
	{
		if (this.icon_view && get_item_attribute("mid") != null && get_item_attribute("mid") != "")
		{
			Gtk.Image img = knots.get_common().cached_image(get_item_attribute("mid"));
			if (img == null)
			{
				string url = (knots.get_connection().uses_ssl() ? "https" : "http") + "://" + knots.get_connection().address() + "/root/resource_file?type=screenshot&mid=" + get_item_attribute("mid") + "&mediatype=0";
				var session = new Soup.SessionSync ();
				var message = new Soup.Message ("GET", url);
				session.authenticate.connect((sess, msg, auth, retrying) => {
				    if (retrying)
				    {
					return;
				    }
				    knots.get_connection().authenticate(false);
				    auth.authenticate(knots.get_connection().username(),knots.get_connection().password());
				});
				message.got_body.connect((message) => {
					try
					{
						
						var filename = "/tmp/knots" + get_item_id().to_string();
						FileUtils.set_contents (filename, (string)message.response_body.data, (int)message.response_body.length);
						Gtk.Image img2 = new Gtk.Image.from_file(filename);
						default_image = img2.get_pixbuf();
						image.set_from_pixbuf(default_image); 
						FileUtils.unlink(filename);
						knots.get_common().cache_image(get_item_attribute("mid"), img2);
					}
					catch (GLib.Error e)
					{
						use_default_images();
					}
				});
				session.send_message (message);
			}
			else
			{
				image.set_from_pixbuf(img.get_pixbuf());
				default_image = img.get_pixbuf();
			}
		}
		else
		{
			use_default_images();
		}
		if (knots.visible_page(knots.get_info()))
			knots.get_info().load_image();
		return false;
	}
	
	public Gdk.Pixbuf get_default_image()
	{
		return default_image;
	}
	
	public void use_default_images()
	{
		if (get_item_type() == ITEM)
		{
			if (get_item_attribute("mediatype") == null || get_item_attribute("mediatype").to_int() != 1)
				default_image = knots.get_common().get_default_video_item_image().get_pixbuf();
			else
				default_image = knots.get_common().get_default_music_item_image().get_pixbuf();
		}
		else
		if (get_item_type() == BUTTON)
			default_image = knots.get_common().get_default_connect_item_image().get_pixbuf();
		else
		if (get_item_type() == SERVER)
			default_image = knots.get_common().get_default_server_item_image().get_pixbuf();
		else
			default_image = knots.get_common().get_default_dir_image().get_pixbuf();
		if (icon_view)
			image.set_from_pixbuf(default_image);
		else
			image.set_from_pixbuf(default_image.scale_simple(64, 64, Gdk.InterpType.BILINEAR));
	}
	
	public int width()
	{
		return icon_view ? 180 : knots.get_window().get_screen().get_width();;
		
	}
	
	public int height()
	{
		return icon_view ? 160 : 80;
	}
}
