using GLib;
using Gtk;
using Hildon;
using Gdk;
using Xml;
using GConf;
using Osso;
using ConIc;

public class Knots : Hildon.Program
{
	Common common;
	Settings settings;
        Hildon.StackableWindow window;
	bool fullscreen;
	Discovery discovery;
	private Osso.Context context;
	Notebook nb;
	public int ORIENTATION = 0;
	public int LANDSCAPE = 0;
	public int PORTRAIT = 1;
	private string version = Version.VERSION;
	public static bool visible;
	public static bool topmost;
	private int rotation;
	private int updating_collection;
	ConIc.Connection con;
	private bool connected;
	private HashTable<string,Gtk.Widget> menu_buttons;
	private HashTable<string,string> profileids;
	private HashTable<string,string> profileplayers;
	private HashTable<string,string> profiletimeouts;
	private Gtk.AboutDialog about;
	
	static int main (string[] args)
	{
                Gtk.init (ref args);
                Gst.init(ref args);
                Knots knots = new Knots ();
                knots.run();
                return 0;
        }
	
        public void run()
	{
		menu_buttons = new HashTable<string,Gtk.Widget>(str_hash, str_equal);
		settings = new Settings();
		discovery = new Discovery(this);
		this.topmost = true;
		context = new Osso.Context("com.nokia.knots2", version, false, null);
		common = new Common(this);
		fullscreen = false;
		Gdk.threads_enter();
                window = new Hildon.StackableWindow ();
                add_window (window);
		Environment.set_application_name("Knots");
		window.key_release_event += (widget, event) => {
			return key_event(widget, event);
		};
		create_layout();
		create_menu();
		window.focus_in_event += do_focus_check;
		window.focus_out_event += do_focus_check;
		context.set_hw_display_event_callback(display_event, this);
		window.show_all ();
		get_browser().get_toolbar_button(5).hide();
		get_browser().get_toolbar().hide();
		window.destroy += clean_up;
		con = new ConIc.Connection();
		int last_rotation = get_settings().get_value_default_to("rotation", "0").to_int();
		if (last_rotation != rotation)
		{
			set_rotation(last_rotation);
		}
		Gdk.Display.get_default().get_default_screen().size_changed += check_orientation;
		connect_server_automatically();
                Gtk.main ();
		Gdk.threads_leave();
        }
        
        public Osso.Status disable_blanking()
        {
        	return context.display_blanking_pause();
        }
	
	public void set_title(string title)
	{
		window.set_title(title);
	}

	public ConIc.Connection get_conic()
	{
		return con;
	}
	
	public void hide_menu()
	{
		get_menu_buttons().for_each(menu_visibility);	
	}
	
	public void menu_visibility(void* key, void* value)
	{
		string name = (string)key;
		get_menu_button(name).hide();
	}
	
	public void create_layout()
	{
		nb = new Notebook();
		nb.show_border = false;
		nb.show_tabs = false;
		Browser browser = new Browser();
		browser.init(this);
		Info info = new Info();
		info.init(this);
		Player player = new Player();
		player.init(this);
		Playlist playlist = new Playlist();
		playlist.init(this);
		nb.append_page(browser, null);
		nb.append_page(info, null);
		nb.append_page(player, null);
		nb.append_page(playlist, null);
		window.add(nb);
	}
	
	public PageWidget get_page(int index)
	{
		return (PageWidget)nb.get_nth_page(index);
	}
	
	public bool visible_page(PageWidget pw)
	{
		return nb.get_nth_page(nb.page) == pw;
	}
	
	public void create_menu()
	{	
		Hildon.AppMenu menu = new Hildon.AppMenu();
		add_connect_menu(menu);
		add_root_menu(menu);
		add_iconview_menu(menu);
		add_sort_menu(menu);
		add_clear_menu(menu);
		add_rotation_menu(menu);
		add_update_collection_menu(menu);
		add_profile_menu(menu);
		add_dynknots_menu(menu);
		add_jump_menu(menu);
		add_play_results_menu(menu);
		add_add_results_menu(menu);
		add_tag_menu(menu);
		add_subtitle_menu(menu);
		add_download_menu(menu);
		add_share_menu(menu);
		add_fm_transmitter_menu(menu);
		add_language_menu(menu);
		add_about_menu(menu);
		window.set_main_menu(menu);
	}
	
	public void add_connect_menu(Hildon.AppMenu menu)
	{
		Hildon.Button connect_automatically = new Hildon.Button.with_text (SizeType.FINGER_HEIGHT, ButtonArrangement.VERTICAL, "Connect automatically", "");
		connect_automatically.clicked += connect_server_automatically;
		Hildon.Button connect_manually = new Hildon.Button.with_text (SizeType.FINGER_HEIGHT, ButtonArrangement.VERTICAL, "Connect manually", "");
		connect_manually.clicked += connect_server_manually;
		menu.append(connect_automatically);
		menu.append(connect_manually);
		menu_buttons.insert("connect_automatically", connect_automatically);
		menu_buttons.insert("connect_manually", connect_manually);
	}
	
	public void add_root_menu(Hildon.AppMenu menu)
	{
		Hildon.Button go_to_root = new Hildon.Button.with_text (SizeType.FINGER_HEIGHT, ButtonArrangement.VERTICAL, "Go to root", "");
		go_to_root.clicked += get_browser().go_to_root;
		menu.append(go_to_root);
		menu_buttons.insert("go_to_root", go_to_root);
	}
	
	public void add_clear_menu(Hildon.AppMenu menu)
	{
		Hildon.Button clear_caches = new Hildon.Button.with_text (SizeType.FINGER_HEIGHT, ButtonArrangement.VERTICAL, "Clear cache", "");
		clear_caches.clicked += (w) => {
			get_common().clear_cache(2);
		};
		menu.append(clear_caches);
		menu_buttons.insert("clear_caches", clear_caches);
	}
	
	public void add_sort_menu(Hildon.AppMenu menu)
	{
		int sorted = get_settings().get_value_default_to("sort", "0").to_int(); 
		string[] fields = {"Added descending", "Added ascending", "Modified descending", "Modified ascending", "Name descending", "Name ascending", "Duration descending", "Duration ascending", "Position descending", "Position ascending", "Path descending", "Path ascending", "Size descending", "Size ascending", "Views descending", "Views ascending", "Random"};
		Hildon.Button sort_button = new Hildon.Button.with_text (SizeType.FINGER_HEIGHT, ButtonArrangement.VERTICAL, "Sort items by", fields[sorted]);
		sort_button.clicked += change_sort;
		menu.append(sort_button);
		menu_buttons.insert("sort", sort_button);
	}
	
	public void add_tag_menu(Hildon.AppMenu menu)
	{
		Hildon.Button tag_button = new Hildon.Button.with_text (SizeType.FINGER_HEIGHT, ButtonArrangement.VERTICAL, "Tag", "");
		tag_button.clicked += get_info().tag_item;
		menu.append(tag_button);
		menu_buttons.insert("tag", tag_button);
	}
	
	public void add_subtitle_menu(Hildon.AppMenu menu)
	{
		Hildon.Button subtitle_button = new Hildon.Button.with_text (SizeType.FINGER_HEIGHT, ButtonArrangement.VERTICAL, "Fetch subtitles", "");
		subtitle_button.clicked += get_info().fetch_subtitles;
		menu.append(subtitle_button);
		menu_buttons.insert("subtitles", subtitle_button);
	}
	
	public void add_language_menu(Hildon.AppMenu menu)
	{
		Hildon.Button language_button = new Hildon.Button.with_text (SizeType.FINGER_HEIGHT, ButtonArrangement.VERTICAL, "Select languages", "");
		language_button.clicked += get_info().select_languages;
		menu.append(language_button);
		menu_buttons.insert("languages", language_button);
	}
	
	public void add_download_menu(Hildon.AppMenu menu)
	{
		Hildon.Button download_button = new Hildon.Button.with_text (SizeType.FINGER_HEIGHT, ButtonArrangement.VERTICAL, "Transfer", "");
		download_button.clicked += get_playlist().download_items;
		menu.append(download_button);
		menu_buttons.insert("download", download_button);
	}
	
	public void add_profile_menu(Hildon.AppMenu menu)
	{
		Hildon.Button profile = new Hildon.Button.with_text (SizeType.FINGER_HEIGHT, ButtonArrangement.VERTICAL, "Transcoding profile", "");
		profile.clicked += change_transcoding_profile;
		menu.append(profile);
		menu_buttons.insert("profile", profile);
	}
	
	public void add_share_menu(Hildon.AppMenu menu)
	{
		Hildon.Button share_button = new Hildon.Button.with_text (SizeType.FINGER_HEIGHT, ButtonArrangement.VERTICAL, "Share", "");
		share_button.clicked += get_playlist().share_playlist;
		menu.append(share_button);
		menu_buttons.insert("share", share_button);
	}
	
	public void add_fm_transmitter_menu(Hildon.AppMenu menu)
	{
		Hildon.Button fm_transmitter_button = new Hildon.Button.with_text (SizeType.FINGER_HEIGHT, ButtonArrangement.VERTICAL, "FM Transmitter", "");
		fm_transmitter_button.clicked += show_fm_transmitter_dialog;
		menu.append(fm_transmitter_button);
		menu_buttons.insert("fm_transmitter", fm_transmitter_button);
	}
	
	public void add_iconview_menu(Hildon.AppMenu menu)
	{
		Hildon.CheckButton icon_view = new Hildon.CheckButton(SizeType.FINGER_HEIGHT);
		icon_view.set_alignment((float)0.5, (float)0.5);
		icon_view.set_label("Download images");
		bool active = get_settings().get_value_default_to("icon_view", "true") == "true";
		icon_view.set_active(active);
		get_browser().set_icon_view(active);
		icon_view.toggled += (w) => {
			get_browser().set_icon_view(((Hildon.CheckButton)w).get_active());
			get_browser().browse();
			if (get_connection().connected())
			{
				if (visible_page(get_playlist()))
					get_playlist().update_items();
				else
					get_playlist().set_update_need(true);
			}
		};
		menu.append(icon_view);
		menu_buttons.insert("icon_view", icon_view);
	}
	
	public void change_sort()
	{
		int sorted = get_settings().get_value_default_to("sort", "0").to_int(); 
		string[] fields = {"Added descending", "Added ascending", "Modified descending", "Modified ascending", "Name descending", "Name ascending", "Duration descending", "Duration ascending", "Position descending", "Position ascending", "Path descending", "Path ascending", "Size descending", "Size ascending", "Views descending", "Views ascending", "Random"};
		var dialog = new PickerDialog (window);
		gtk_window_set_portrait_flags(dialog, Hildon.PortraitFlags.SUPPORT);
		dialog.set_title ("Sort items by");
		ListStore sortnames = new ListStore (1, typeof (string));
		TreeIter iter;
		for (int i = 0; i < fields.length; i++) {
			sortnames.append (out iter);
			sortnames.set_value (iter, 0, fields[i]);
		}
		var selector = new TouchSelector ();
		selector.append_text_column (sortnames, true);
		dialog.set_selector (selector);
		selector.set_active(0, sorted);
		var res = dialog.run ();
		if (res == ResponseType.OK)
		{
			get_settings().set_value("sort", selector.get_active(0).to_string());
			get_menu_button("sort").set_value(fields[selector.get_active(0)]);			
		}
		dialog.destroy ();
	}
	
	public void show_fm_transmitter_dialog()
        {
        	this.context.plugin_execute("libcpfmtx.so", null, true);
        }
	
	public void update_transcode_profiles()
	{
		bool selected_profile = false;
		string current_profile = get_settings().get_value_default_to("transcoding_profile", "6");
		profileids = new HashTable<string,string>(str_hash, str_equal);
		profileplayers = new HashTable<string,string>(str_hash, str_equal);
		profiletimeouts = new HashTable<string,string>(str_hash, str_equal);
		get_connection().set_url_cache(false);
		XMList list = new XMList(get_connection().fetch("/external/transcoding_profiles"));
		foreach(HashTable<string,string> ht in list.items())
		{
			string profile_id = (string)ht.lookup("id");
			if (profile_id == current_profile)
				selected_profile = true;
		}
		if (!selected_profile)
		{
			current_profile = "6";
		}
		foreach(HashTable<string,string> ht in list.items())
		{
			string profile_name = (string)ht.lookup("name");
			string profile_id = (string)ht.lookup("id");
			string profile_player = (string)ht.lookup("player");
			string profile_timeout = (string)ht.lookup("network_timeout");
			if (profile_timeout == null || profile_timeout == "")
				profile_timeout = "30";
			profileids.insert(profile_name, profile_id);
			profileplayers.insert(profile_name, profile_player);
			profiletimeouts.insert(profile_name, profile_timeout);
			if (profile_id == current_profile)
			{
				get_settings().set_value("transcoding_profile", profile_id);
				get_menu_button("profile").set_value(profile_name);
				select_player(profile_player);
				set_timeout(profile_timeout);
			}
		}
	}
	
	public void change_transcoding_profile()
	{
		string[] selected_profile = select_transcoding_profile("Select transcoding profile");
		if (selected_profile[0] != null)
		{
			get_settings().set_value("transcoding_profile", selected_profile[0]);
			select_player((string)profileplayers.lookup(selected_profile[1]));
			set_timeout((string)profiletimeouts.lookup(selected_profile[1]));
			get_menu_button("profile").set_value(selected_profile[1]);
		}
	}
	
	public string[] select_transcoding_profile(string title)
	{
		string[] selected_profile = new string[2];
		var dialog = new PickerDialog (window);
		gtk_window_set_portrait_flags(dialog, Hildon.PortraitFlags.SUPPORT);
		dialog.set_title (title);
		ListStore profilenames = new ListStore (1, typeof (string));
		TreeIter iter;
		var pnames = profileids.get_keys();
		int selected = 0;
		for (int i = 0; i < pnames.length(); i++) {
			string pname = (string)pnames.nth_data(i);
			profilenames.append (out iter);
			profilenames.set_value (iter, 0, pname);
			if (get_menu_button("profile").get_value() == pname)
				selected = i;
		}
		var selector = new TouchSelector ();
		selector.append_text_column (profilenames, true);
		dialog.set_selector (selector);
		selector.set_active(0, selected);
		var res = dialog.run ();
		if (res == ResponseType.OK)
		{
			selected_profile[1] = (string)pnames.nth_data(selector.get_active(0));
			selected_profile[0] = (string)profileids.lookup(selected_profile[1]);
		}
		dialog.destroy ();
		return selected_profile;
	}
	
	public void select_player(string player)
	{
		if (player != null && player == "mplayer" && FileUtils.test("/usr/bin/mplayer", FileTest.EXISTS))
		{
			get_settings().set_value("player", "mplayer");
		}
		else
			get_settings().set_value("player", "gstreamer");
		
	}
	
	public void set_timeout(string timeout)
	{
		if (timeout != null && timeout.to_int() > 0)
		{
			get_settings().set_value("default_timeout", timeout);
		}
		else
		{
			get_settings().set_value("default_timeout", "30");
		}
		get_connection().update_timeout();
	}
	
	public Hildon.Button get_menu_button(string id)
	{
		return (Hildon.Button)menu_buttons.lookup(id);
	}
	
	public HashTable<string,Gtk.Widget> get_menu_buttons()
	{
		return menu_buttons;
	}
	
	public void add_jump_menu(Hildon.AppMenu menu)
	{
		Hildon.Button jump_to = new Hildon.Button.with_text (SizeType.FINGER_HEIGHT, ButtonArrangement.VERTICAL, "Jump to page", "");
		jump_to.clicked += get_browser().change_page;
		menu.append(jump_to);
		jump_to.hide();
		menu_buttons.insert("jump_to", jump_to);
	}
	
	public void add_play_results_menu(Hildon.AppMenu menu)
	{
		Hildon.Button play_results = new Hildon.Button.with_text (SizeType.FINGER_HEIGHT, ButtonArrangement.VERTICAL, "Play results", "");
		play_results.clicked += get_browser().play_results;
		menu.append(play_results);
		play_results.hide();
		menu_buttons.insert("play_results", play_results);
	}
	
	public void add_add_results_menu(Hildon.AppMenu menu)
	{
		Hildon.Button add_results = new Hildon.Button.with_text (SizeType.FINGER_HEIGHT, ButtonArrangement.VERTICAL, "Add results to playlist", "");
		add_results.clicked += () => {
			try
			{
				Thread.create(get_browser().add_results_in_thread, true);
			}
			catch (ThreadError e)
			{
			
			}
		};
		menu.append(add_results);
		add_results.hide();
		menu_buttons.insert("add_results", add_results);
	}
	
	public void add_rotation_menu(Hildon.AppMenu menu)
	{
		Hildon.Button current_rotation = new Hildon.Button.with_text (SizeType.FINGER_HEIGHT, ButtonArrangement.VERTICAL, "Rotation", get_rotation() == 0 ? "Landscape" : "Portrait");
		current_rotation.clicked += (w) => {
			set_rotation(get_rotation() == 0 ? 1 : 0);
			get_settings().set_value("rotation", get_rotation() == 0 ? "1" : "0");
		};
		menu.append(current_rotation);
		menu_buttons.insert("rotation", current_rotation);
	}
	
	public void add_update_collection_menu(Hildon.AppMenu menu)
	{
		Hildon.Button update_item = new Hildon.Button.with_text (SizeType.FINGER_HEIGHT, ButtonArrangement.VERTICAL, "Update collection", "");
		updating_collection = -1;
		update_item.clicked += () => {
			update_server_collection();
		};
		menu.append(update_item);
		menu_buttons.insert("update_collection", update_item);
	}
	
	public bool update_server_collection()
	{
		if (updating_collection == -1 && get_connection().connected())
		{
			get_connection().set_url_cache(false);
			XMList list = new XMList(get_connection().fetch("/external/root_paths"));
			if (list.itemcount() > 0)
			{
				string[] ids = new string[0];
				ids += "0";
				var dialog = new PickerDialog (window);
				dialog.height_request = 440;
				gtk_window_set_portrait_flags(dialog, Hildon.PortraitFlags.SUPPORT);
				dialog.set_title ("Select what to update");
				ListStore pathlist = new ListStore (1, typeof (string));
				TreeIter iter;
				pathlist.append (out iter);
				pathlist.set_value (iter, 0, "Update everything");
				foreach(HashTable<string,string> ht in list.items())
				{
					pathlist.append (out iter);
					pathlist.set_value (iter, 0, (string)ht.lookup("path"));
					ids += (string)ht.lookup("id");
				}
				var selector = new TouchSelector ();
				selector.append_text_column (pathlist, true);
				dialog.set_selector (selector);
				selector.unselect_all(0);
				var res = dialog.run ();
				if (res == ResponseType.OK)
				{
					get_menu_button("update_collection").set_value("In progress");
					updating_collection = ids[selector.get_active(0)].to_int();
					try
					{
						Thread.create(update_collection, true);
					}
					catch (GLib.Error e)
					{
					
					}
				}
				dialog.destroy();
			}
			else
			{
				alert("No paths found to update.");
			}
		}
		return false;
	}
	
	public void* update_collection()
	{
		get_connection().set_url_cache(false);
		get_connection().set_timeout(600);
		get_connection().fetch("/external/update_collection?id=" + updating_collection.to_string());
		updating_collection = -1;
		GLib.Idle.add(stop_collection_update);
		return null;
	}
	
	public bool stop_collection_update()
	{
		get_menu_button("update_collection").set_value("");
		alert("Collection updated.");
		get_common().clear_cache(1);
		return false;
	}
	
	public static void open_page(AboutDialog about, string link)
	{
		try
		{
			Process.spawn_command_line_async("/usr/bin/browser --url \"" + link + "\" > /dev/null 2> /dev/null &");
		}
		catch (GLib.SpawnError se)
		{
		}
		about.hide();
	}
		
	public void add_about_menu(Hildon.AppMenu menu)
	{
		Hildon.Button about_item = new Hildon.Button.with_text (SizeType.FINGER_HEIGHT, ButtonArrangement.VERTICAL, "About", "");
		about_item.clicked += show_about;
		menu.append(about_item);
		menu_buttons.insert("about", about_item);
	}
	
	public void show_about()
	{
		if (about == null)
		{
			about = new Gtk.AboutDialog();
			gtk_window_set_portrait_flags(about, Hildon.PortraitFlags.SUPPORT);
			about.version = get_version();
			about.copyright = "Copyright © 2010 Janne Mäkinen";
			about.authors = {"Janne Mäkinen <janne.makinen@surffi.fi>", null};
			about.artists = {"Human-O2 IconsSet", "Oliver Scholtz", null};
			about.set_url_hook(open_page);
			try
			{
				about.logo = new Gdk.Pixbuf.from_file("/usr/share/icons/hicolor/scalable/apps/knots2.png");
			}
			catch (GLib.Error e)
			{
				print("%s\n", e.message);
			}
			about.response += () => { about.hide(); };
		}
		if (get_connection().connected())
		{
			about.website = "http" + (get_connection().uses_ssl() ? "s" : "") + "://" + get_connection().address();
		}
		else
		{
			about.website = "http://wiki.maemo.org/Knots2";
			
		}
		about.run();
	}
	
	public void toggle_fullscreen()
	{
		fullscreen = !fullscreen;
		if (fullscreen)
			window.fullscreen();
		else
			window.unfullscreen();
	}

	public static void display_event(Osso.DisplayState state, void* data)
	{
		Knots knots = (Knots)data;
		if (state == Osso.DisplayState.ON)
			visible = true;
		else
		if (state == Osso.DisplayState.OFF)
			visible = false;
		for (int i = 0; i < knots.get_notebook().get_n_pages(); i++)
		{
			((PageWidget)knots.get_notebook().get_nth_page(i)).display_state_changed(state);
		}
	}

	public Settings get_settings()
	{
		return settings;
	}
	
	public bool is_visible()
	{
		return visible && topmost;
	}
	
	public void set_rotation(int i)
	{
		if (i == 0)
			gtk_window_set_portrait_flags(window, 0);
		else
			gtk_window_set_portrait_flags(window, Hildon.PortraitFlags.REQUEST);
		get_menu_button("rotation").set_value(i == 0 ? "Landscape" : "Portrait");
	}
	
	public bool is_fullscreen()
	{
		return this.fullscreen;
	}
	
	public int get_rotation()
	{
		return this.ORIENTATION;
	}
	
	public Hildon.Window get_window()
	{
		return window;
	}
	
	public string get_version()
	{
		return version;
	}
	
	public bool check_topmost()
	{
		if (window.get_is_topmost() != topmost)
		{
			topmost = window.get_is_topmost();
			for (int i = 0; i < get_notebook().get_n_pages(); i++)
			{
				((PageWidget)get_notebook().get_nth_page(i)).window_state_changed(topmost);
			}
			
		}
		if (topmost)
			check_clipboard_shares();
		return false;
	}
	
	public void check_clipboard_shares()
	{
		Gtk.Clipboard clipboard = Gtk.Clipboard.get(Gdk.Atom.intern_static_string("CLIPBOARD"));
		if (clipboard != null)
		{
			clipboard.request_text(check_share);
		}
	}
	
	public void check_share(Clipboard clipboard, string text)
	{
		if (text != null && text != get_settings().get_value("last_share"))
		{
			string[] tokens = Regex.split_simple("(.*?):\\/\\/(.*?):(.*?)@(.*?):(.*?)\\/", text);
			if (tokens.length == 7 && tokens[6].str("root/share") != null)
			{
				get_settings().set_value("last_share", text);
				MessageDialog dialog = new MessageDialog.with_markup(window, DialogFlags.MODAL, Gtk.MessageType.OTHER, Gtk.ButtonsType.OK_CANCEL, "Play share?");
				dialog.get_image().hide();
				((Label)dialog.label).selectable = false;
				gtk_window_set_portrait_flags(dialog, Hildon.PortraitFlags.SUPPORT);
				dialog.show_all();
				var response = dialog.run();
				if (response == ResponseType.OK)
				{
					get_player().play(text, get_player().SHARE);
				}
				dialog.destroy();
			}
		}
	}
	
	public void add_dynknots_menu(Hildon.AppMenu menu)
	{
		Hildon.Button dynknots_auth_button = new Hildon.Button.with_text (SizeType.FINGER_HEIGHT, ButtonArrangement.VERTICAL, "Remote discovery", get_settings().get_value("dynknots_key") != null ? "Enabled" : "Disabled");
		dynknots_auth_button.clicked += (w) => {
			dynknots_auth();
		};
		menu.append(dynknots_auth_button);
		menu_buttons.insert("dynknots", dynknots_auth_button);
	}
	
	public void dynknots_auth()
	{
		if (get_settings().get_value("dynknots_key") == null)
		{
			Hildon.LoginDialog login = new LoginDialog(get_window());
			login.set_message("Login with your remote discovery credentials.\nAccount can be created in server settings.");
			var response = login.run();
			if (response == ResponseType.OK)
			{
				string username = login.get_username();
				string password = login.get_password();
				string key = get_connection().fetch_from_address("/knots2/dynknots.php?action=login&username=" + username + "&password=" + password, "nakkiboso.com", null, null);
				if (key != null && key.strip().length == 16)
				{
					get_settings().set_value("dynknots_key", key.strip());
					alert("Authentication successful");
					get_menu_button("dynknots").set_value("Enabled");
				}
				else
				{
					alert("Authentication failed");
				}
			}
			login.destroy();
		}
		else
		{
			get_settings().unset_value("dynknots_key");
			alert("Remote discovery disabled");
			get_menu_button("dynknots").set_value("Disabled");
		}
	}
	
	public bool do_focus_check(EventFocus event)
	{
		GLib.Timeout.add(200, check_topmost);
		return false;
	}
	
	public void check_orientation()
	{
		int screen_width = window.get_screen().get_width();
		int screen_height = window.get_screen().get_height();
		int new_orientation =  screen_width > screen_height ? LANDSCAPE : PORTRAIT;
		if (new_orientation != ORIENTATION)
		{
			ORIENTATION = new_orientation;
			for (int i = 0; i < nb.get_n_pages(); i++)
			{
				((PageWidget)nb.get_nth_page(i)).orientation_change();
			}
		}
	}
	
	public int get_screen_width()
	{
		return window.get_screen().get_width();
	}
	
	public int get_screen_height()
	{
		return window.get_screen().get_height();
	}
	
	public Discovery get_connection()
	{
		return discovery;
	}
	
	public void connect_server_manually()
	{
		if (!get_player().is_playing())
		{
			if (!connected)
			{
				alert("Trying to connect, please wait.");
				con.connection_event += (s) => {
					if (s.get_status() == ConIc.ConnectionStatus.CONNECTED || get_settings().get_value("ignore_conic") != null)
					{
						this.connected = true;
						connect_server_manually();
					}
					else
					{
						disconnect_servers();
					}
				};
				con.connect(ConIc.ConnectFlags.NONE);
			}
			else
			{
				string? server = get_connection().show_address_dialog();
				if (server != null)
				{
					if (get_connection().load_connection(server, true, true))
					{
						get_connection().add_server(server);
					}
					if (get_connection().server_count() == 1)
					{
						connect_server();
					}
					else
					if (get_connection().server_count() > 1)
					{
						get_browser().show_serverlist();
					}
					else
					{
						disconnect_servers();
					}
					get_browser().reveal();
				}
			}
		}
	}
	
	public void connect_server_automatically()
	{
		if (!get_player().is_playing())
		{
			if (!connected)
			{
				alert("Trying to connect, please wait.");
				con.connection_event += (s) => {
					if (s.get_status() == ConIc.ConnectionStatus.CONNECTED || get_settings().get_value("ignore_conic") != null)
					{
						this.connected = true;
						connect_server_automatically();
					}
					else
					{
						disconnect_servers();
					}
				};
				con.connect(ConIc.ConnectFlags.NONE);
			}
			else
			{
				/*
				try
				{
					gtk_window_set_progress_indicator(window, 1);
					Thread.create(discover_in_thread, true);
					
				}
				catch (ThreadError e)
				{
					print("ThreadError: %s\n", e.message);
				}
				*/
				discover_in_thread();
			}
		}
	}
	
	public void* discover_in_thread()
	{
		get_connection().discover_server_address();
		//GLib.Idle.add(handle_discovery);
		handle_discovery();
		return null;
	}
	
	public bool handle_discovery()
	{
		if (get_connection().server_count() == 1)
		{
			connect_server();
		}
		else
		if (get_connection().server_count() > 1)
		{
			get_browser().show_serverlist();
		}
		else
		{
			disconnect_servers();
		}
		get_browser().reveal();
		return false;
	}
	
	public void connect_server()
	{
		/*
		alert("Connected to server " + get_connection().server_name());
		try
		{
			Thread.create(connect_server_in_thread, true);
			
		}
		catch (ThreadError e)
		{
			print("ThreadError: %s\n", e.message);
		}
		*/
		connect_server_in_thread();
	}
	
	public void* connect_server_in_thread()
	{
		get_playlist().update_playlists();
		get_playlist().select_default_playlist();
		get_playlist().update_list();
		get_playlist().set_update_need(true);
		update_transcode_profiles();
		get_browser().browse();
		alert("Connected to server " + get_connection().server_name());
		return null;
	}
	
	public void disconnect_servers()
	{
		alert("Not connected to server");
		get_browser().show_disconnect_message();
	}
	
	public Common get_common()
	{
		return common;
	}
	
	public Browser get_browser()
	{
		return (Browser)nb.get_nth_page(0);
	}
	
	public Info get_info()
	{
		return (Info)nb.get_nth_page(1);
	}
	
	public Playlist get_playlist()
	{
		return (Playlist)nb.get_nth_page(3);
	}
	
	public Player get_player()
	{
		return (Player)nb.get_nth_page(2);
	}
	
	public Notebook get_notebook()
	{
		return nb;
	}
	
	public void alert(string str){
	  	Hildon.Banner.show_information(window, "knots2", str);
	}
	
	public void puts(string message)
	{
		print("%s\n", message);
	}

	public void clean_up()
	{
		if (get_player().is_playing())
		{
			get_player().stop_in_thread();
			get_player().on_stop(true);
		}
		Gtk.main_quit();
	}
	
	public bool key_event(Gtk.Widget w, Gdk.EventKey ev)
	{
		if (get_player().is_playing())
		{
			return get_player().key_event(ev);
		}
		return false;
	}
}

