#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <time.h>
#include <string.h>
#include <signal.h>
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#define KNOTS_PORT 1978
#define KNOTS_GROUP "225.4.5.6"
#define MAXBUFSIZE 65536

static int fd;

static void alarm_handler(int sig) 
{
	shutdown(fd, 2);
	close(fd);
	exit(0);
} 

int main(int argc, char *argv[])
{
	int timeout = argc != 2 ? 1 : atoi(argv[1]);
	struct sockaddr_in addr;
	int status, socklen;
	char buffer[MAXBUFSIZE];
	strcpy(buffer, "knots\n");
	if ((fd = socket(AF_INET,SOCK_DGRAM,0)) < 0)
	{
		perror("socket");
		return 1;
	}
	memset(&addr,0,sizeof(addr));
	addr.sin_family=AF_INET;
	addr.sin_addr.s_addr=inet_addr(KNOTS_GROUP);
	addr.sin_port=htons(KNOTS_PORT);
	socklen = sizeof(struct sockaddr_in);
	if (sendto(fd,buffer,strlen(buffer),0,(struct sockaddr *) &addr, sizeof(addr)) < 0)
	{
		perror("sendto");
		return 1;
	}
	else
	{
		signal(SIGALRM, alarm_handler); 
		alarm(timeout); 
		while((status = recvfrom(fd, buffer, MAXBUFSIZE, 0, (struct sockaddr *)&addr, &socklen)) >= 0)
		{
			char uip[20];
			strcpy(uip,inet_ntoa(addr.sin_addr));
			printf("%s/%s\n", buffer, uip);
 		} 
	}
	return 0;
}
