/* This file is part of the KMPlayer project
 *
 * Copyright (C) 2004 Koos Vriezen <koos.vriezen@xs4all.nl>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _KMPLAYER_H_
#define _KMPLAYER_H_

#include <libosso.h>

#define MAEMO_NO_EXPORT __attribute__ ((visibility("hidden")))

#define GCONF_KEY_PREFIX "/apps/maemo/kmplayer"
#define GCONF_KEY_DATA_DIR GCONF_KEY_PREFIX"/data_dir"
#define GCONF_KEY_RECENT_FILE GCONF_KEY_PREFIX"/recent_file"
#define GCONF_KEY_PLAYLIST_FILE GCONF_KEY_PREFIX"/playlist_file"
#define GCONF_KEY_LOCATION_URL GCONF_KEY_PREFIX"/location"
#define GCONF_KEY_PLAYER GCONF_KEY_PREFIX"/player"
#define GCONF_KEY_VO GCONF_KEY_PREFIX"/video_output"
#define GCONF_KEY_SAVE_FOLDER GCONF_KEY_PREFIX"/save_folder"
#define GCONF_KEY_MIME GCONF_KEY_PREFIX"/mimetypes/"
#define GCONF_KEY_LISTS GCONF_KEY_PREFIX"/lists"
#define GCONF_KEY_KEYS GCONF_KEY_PREFIX"/keys/"

#define HSPLIT 320
#define VSPLIT 260

#define CONTROL(app) ((KMPlayer::Control *)app->control)
#define VIEWAREA(app) ((KMPlayer::ViewArea *)app->viewarea)

#define NOT_PLAYING 0
#define PLAYING 1
#define PAUSED 2

#ifdef __cplusplus
extern "C" {
#endif

/*typedef struct _GConfClient GConfClient;*/

/* Application UI data struct */
typedef struct _Application {
    GObject *program;
    GtkWindow *window;
    GtkWindow *window_fullscreen;
    osso_context_t *osso_context;
    GtkWidget * main_toolbar;
    GtkToolItem * tb_play;
    GtkToolItem * tb_pause;
    GtkToolItem * tb_save;
    GtkToolItem * tb_stop;
    GtkToolItem * tb_location;
    GtkToolItem * tb_progress;
    GtkWidget * playlist_view;
    GtkWidget * infopanel_view;
    GtkWidget * info_viewport;
    GtkWidget * html_infopanel_view;
    GtkWidget * html_viewport;
    GtkWidget * view_area;
    GtkWidget * view_area_fullscreen;
    GtkWidget * menu_item_playlist_copy;
    GtkWidget * menu_item_playlist_paste;
    GtkWidget * menu_item_playlist_paste_in_group;
    GtkWidget * menu_item_playlist_cut;
    GtkWidget * menu_item_playlist_showall;
    GtkWidget * menu_item_playlist_edit;
    GtkWidget * menu_item_playlist_title;
    GtkWidget * menu_item_media_server;
    GtkWidget * menu_item_mplayer;
    GtkWidget * menu_item_npp;
    GtkWidget * menu_item_mplayer_vo;
    GtkWidget * tb_item_playlist_commit;
    GtkWidget * location_bar;
    GtkWidget * progress_bar;
    GtkPaned * hsplit_view;
    GtkPaned * vsplit_view;
    GtkWidget * isplit_view;
    GtkCellRenderer * playlist_cell_renderer;
    void *control;
    void *viewarea;
    gchar *save_folder;
    short playlists_tree_id;
    short recents_tree_id;
    bool in_tree_update; /* no events when updating*/
    bool fullscreen;
    bool top_most_window;
    int playing;
} Application;


GtkWidget * createTreeView (Application * app);
void togglePlaylistShow (GtkCheckMenuItem *checkmenuitem, Application * app);
void togglePlaylistShowAll (GtkCheckMenuItem *checkmenuitem, Application * app);
void togglePlaylistEdit (GtkCheckMenuItem *checkmenuitem, Application * app);
void toggleMediaServer (GtkCheckMenuItem *radio, Application * app);
void toggleVO (GtkCheckMenuItem *check, Application * app);
gboolean cb_mainview_delete (GtkObject *w, GdkEvent *event, Application *app);
void cb_mainview_close (GtkObject *w, Application *app);
gboolean cb_keyPressed (GtkWidget *, GdkEventKey * e, Application *app);
void cb_row_activated (GtkTreeView *treeview, GtkTreePath *path, GtkTreeViewColumn *arg2, Application * app);
void cb_playlist_edit_commit (GtkButton * button, Application * app);
void cb_openUrls (void *app, int argc, gchar **argv);
void cb_view_area_realized (GtkWidget *widget, Application * app);
void cb_view_area_expose (GtkWidget *widget, GdkEventExpose *event, Application * app);
void cb_view_area_configure (GtkWidget *widget, GdkEventConfigure *event, Application * app);
void cb_view_area_button_press (GtkWidget *widget, GdkEventButton *event, Application * app);
void cb_playlistMenuActivate (GtkButton * button, Application * app);
void generatorMenuActivate (GtkMenuItem *item, Application * app);
void cb_playlistCopy (GtkButton * button, Application * app);
void cb_playlistPaste (GtkButton * button, Application * app);
void cb_playlistPasteInNewGroup (GtkButton * button, Application * app);
void cb_playlistCut (GtkButton * button, Application * app);
void cb_playlistTitle (GtkButton * button, Application * app);
void cb_playlist_prev (GtkButton * button, void *ctr);
void cb_playlist_play (GtkButton * button, void *ctr);
void cb_playlist_next (GtkButton * button, void *ctr);
void cb_playlist_stop (GtkButton * button, void *ctr);
gboolean playlist_selected (Application *app, GValue *icon, GValue *text);
void cb_favorites_add (Application *app);
void progressValueChanged(GtkWidget *w, Application * app);
gboolean cb_scheduledPaint (void * p);
gboolean cbViewAreaFullscreenMapped (GtkWidget *w, GdkEvent *, Application *a);
void cbViewAreaFullscreenUnmapped (GtkWidget *w, Application *a);
void cb_fullscreen_destoyed (GtkObject *o, Application *app);

void save_locationbar (Application * app);
gboolean locationbarGainFocus (GtkWidget *, GdkEventFocus *, Application *app);

Application *app_new () MAEMO_NO_EXPORT;
void app_destroy (Application *app) MAEMO_NO_EXPORT;
void app_init_control (Application *app) MAEMO_NO_EXPORT;
void app_insert_location (Application *app, const char *loc) MAEMO_NO_EXPORT;
void app_open_location (const char *filename, Application *app) MAEMO_NO_EXPORT;
void app_normal_screen (Application *app) MAEMO_NO_EXPORT;
void app_full_screen (Application *app) MAEMO_NO_EXPORT;
void app_update_screen_blanking (Application *app) MAEMO_NO_EXPORT;
void app_set_suspend (Application *app, bool suspend) MAEMO_NO_EXPORT;
void app_set_info_content (Application *app, const char * utf8, bool plaintext) MAEMO_NO_EXPORT;
void app_set_playing (Application *app, int) MAEMO_NO_EXPORT;
void app_set_title (const char *title, Application *app) MAEMO_NO_EXPORT;
gchar *app_file_chooser (Application *app, const char *path, GtkFileChooserAction act);
void app_store_save_directory (Application *app, gchar *path);

void openFile (Application *app, const gchar *path) MAEMO_NO_EXPORT;
void saveFile (Application *app, bool as_xml) MAEMO_NO_EXPORT;
void newFile (Application *app) MAEMO_NO_EXPORT;

/*#define KMPLAYER_DEBUG*/
#ifdef KMPLAYER_DEBUG
void sig_usr1 (int i);
#endif

#ifdef __cplusplus
}
#endif

#endif
