#include <unistd.h>

#include "test.h"
#include "../src/expression.h"
#include "../src/kmplayerplaylist.h"

int KMPlayer::connection_counter;

using namespace KMPlayer;

int main() {
    g_thread_init (NULL);
    g_type_init();
    String book_src = "<books>"
        "  <book price='10p'>"
        "    <title>Tom Sawyer</title>"
        "    <author>Mark Twain</author>"
        "  </book>"
        "  <book>"
        "    <title>Uncle Tom's Cabin</title>"
        "    <author>Harriet Beecher Stowe</author>"
        "  </book>"
        "  <book price='5$'>"
        "    <title>Pygmalion</title>"
        "    <author>George Bernard Shaw</author>"
        "  </book>"
        "</books>";
    TextStream book_in (&book_src);
    NodePtr books = new Document (String ());
    readXML (books, book_in, String ());
    {
        TEST_INFO (Test reading books);
        TEST_VERIFY (books->childNodes ().length () == 1);
    }
    {
        TEST_INFO (Test /books/book == 3);
        Expression *expr = evaluateExpr ("/books/book");
        expr->setRoot (books);
        TEST_VERIFY (expr->toInt () == 3);
        delete expr;
    }
    {
        TEST_INFO (Test "//book == 3");
        Expression *expr = evaluateExpr ("//book");
        expr->setRoot (books);
        TEST_VERIFY (expr->toInt () == 3);
        delete expr;
    }
    {
        TEST_INFO (Test "/books/book[@price='5$'] == 1");
        Expression *expr = evaluateExpr ("/books/book[@price='5$']");
        expr->setRoot (books);
        NodeValueList *lst = expr->toNodeList ();
        TEST_VERIFY (lst->length () == 1);
        delete lst;
        delete expr;
    }
    {
        TEST_INFO (Test "@price of third book] == '5$'");
        Expression *expr = evaluateExpr ("/books/book[3]/@price");
        expr->setRoot (books);
        TEST_VERIFY (expr->toString () == "5$");
        delete expr;
    }
    {
        TEST_INFO (Test "/books/book[@price='5$']/title == Pygmalion");
        Expression *expr = evaluateExpr ("/books/book[@price='5$']/title");
        expr->setRoot (books);
        TEST_VERIFY (expr->toString () == "Pygmalion");
        delete expr;
    }
    {
        TEST_INFO (Test "/hook/book[3]/@price == '5$'");
        Expression *expr = evaluateExpr ("/books/book[3]/@price");
        expr->setRoot (books);
        TEST_VERIFY (expr->toString () == "5$");
        delete expr;
    }
    {
        TEST_INFO (Test "@price == '5$' using last book as root");
        Expression *expr = evaluateExpr ("/books/book[last()]");
        expr->setRoot (books);
        NodeValueList *lst = expr->toNodeList ();
        TEST_VERIFY (lst->first ());
        if (lst->first ()) {
            NodePtr b3 = lst->first ()->data.node;
            Expression *expr2 = evaluateExpr ("@price");
            expr2->setRoot (b3);
            TEST_VERIFY (expr2->toString () == "5$");
            delete expr2;
        }
        delete lst;
        delete expr;
    }
    {
        TEST_INFO (Test sorting "/hook/book" on /title);
        Expression *expr = evaluateExpr ("sort('/books/book','/title')");
        expr->setRoot (books);
        NodeValueList *lst = expr->toNodeList ();
        NodeValueItem *itm = lst->first ();
        TEST_VERIFY (itm);
        if (itm) {
            TEST_VERIFY (itm->data.node->firstChild ()->nodeValue () ==
                    "Pygmalion");
            itm = itm->nextSibling ();
            TEST_VERIFY (itm);
            if (itm) {
                TEST_VERIFY (itm->data.node->firstChild ()->nodeValue () ==
                        "Tom Sawyer");
                itm = itm->nextSibling ();
                TEST_VERIFY (itm);
                if (itm) {
                    TEST_VERIFY (itm->data.node->firstChild ()->nodeValue () ==
                            "Uncle Tom's Cabin");
                }
            }
        }
        delete lst;
        delete expr;
    }
    {
        TEST_INFO (Test sorting "/hook/book" on @price);
        Expression *expr = evaluateExpr ("sort('/books/book','@price')");
        expr->setRoot (books);
        NodeValueList *lst = expr->toNodeList ();
        NodeValueItem *itm = lst->first ();
        TEST_VERIFY (itm);
        if (itm) {
            TEST_VERIFY (static_cast <Element *>(itm->data.node)->
                    getAttribute ("price").isEmpty ());
            itm = itm->nextSibling ();
            TEST_VERIFY (itm);
            if (itm) {
                TEST_VERIFY (static_cast <Element *>(itm->data.node)->
                        getAttribute ("price") == "10p");
                itm = itm->nextSibling ();
                TEST_VERIFY (itm);
                if (itm) {
                    TEST_VERIFY (static_cast <Element *>(itm->data.node)->
                            getAttribute ("price") == "5$");
                }
            }
        }
        delete lst;
        delete expr;
    }
    {
        TEST_INFO (Test "/books/book[@price='5$'] | //book[@price='10p'] => 2");
        Expression *expr = evaluateExpr ("/books/book[@price='5$'] | //book[@price='10p']");
        expr->setRoot (books);
        NodeValueList *lst = expr->toNodeList ();
        TEST_VERIFY (lst->length () == 2);
        NodeValueItem *itm = lst->first ();
        if (itm) {
            TEST_VERIFY (static_cast <Element *>(itm->data.node)->
                    getAttribute ("price") == "5$");
            itm = itm->nextSibling ();
            if (itm)
                TEST_VERIFY (static_cast <Element *>(itm->data.node)->
                        getAttribute ("price") == "10p");
        }
        delete lst;
        delete expr;
    }
    {
        TEST_INFO (Test "string-join(//book[3]/title | //book[3]/@price, ' costs ')");
        Expression *expr = evaluateExpr ("string-join(//book[3]/title | //book[3]/@price, ' costs ')");
        expr->setRoot (books);
        TEST_VERIFY (expr->toString () == "Pygmalion costs 5$");
        delete expr;
    }
    {
        TEST_INFO (Test "//book[not(@price)]/title == Uncle Tom's Cabin");
        Expression *expr = evaluateExpr ("//book[not(@price)]/title");
        expr->setRoot (books);
        TEST_VERIFY (expr->toString () == "Uncle Tom's Cabin");
        delete expr;
    }
    books->document ()->dispose ();
    return 0;
}
