/*
 * Copyright (C) 2008-2010 Petrozavodsk State University
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */
/*
 * Google Calendar Module (Module Initialization and Connection Callbacks)
 * Author: Epifanov S.A.
 * Last Modification Date: 18.03.2010
*/

#include <google.h>

#ifdef TEST
#include "../test/CTF/src/ctf.h"
#endif

void kimi_module_initialize(Kimi* kimi, Module* google_module)
{
    printf("google_module init\n");
    google_module_data* gm_data = calloc(1, sizeof(google_module_data));

    /* Initialize Module Config*/

    gm_data->conf = kimi_conf_create_config_module(kimi, MOD_ID, "Google_Calendar", NULL);

    kimi_conf_register_option(gm_data->conf, "login", "Login", OT_STRING,
			      OF_DISPLAYABLE|OF_STORABLE, NULL);

    kimi_conf_register_option(gm_data->conf, "password", "Password", OT_PASSWORD,
			      OF_DISPLAYABLE|OF_STORABLE, NULL);

    /* Initialize Module data and Functions */
    google_module->service_name = strdup(GOOGLE_SERVICE_STR);

    google_module->service_string = strdup(MOD_ID);

    google_module->data = (void*) gm_data;

    google_module->service_pixmap = GOOGLE_MODULE_ICON;

    google_module->get_event_by_id = NULL; //TODO: google_events_download modification to get events by ID ;)
    google_module->store_event = google_event_upload;
    google_module->remove_event = NULL; //TODO: Realize remove_event function
    google_module->get_events_by_period = google_get_by_period;

    /*Osso Initialization*/
#ifdef MAEMO5_ENABLED
    printf("google_module: OSSO INIT\n");
    g_debug("google_module: OSSO Initialization\n");
    gm_data->osso_context = osso_initialize(OSSO_GOOGLE_SERVICE, VERSION, FALSE, NULL);
    /* Check that initialization was ok */
    if (gm_data->osso_context == NULL) {
	g_debug("google_module: osso initialization failed!");
        return OSSO_ERROR;
    }

    gm_data->connection = con_ic_connection_new();
/*FIXME Signal Does't work
*/    printf("signal connection");
    g_debug("signal connection...");
    g_signal_connect(G_OBJECT(gm_data->connection), "connection-event", 
                     G_CALLBACK(connection_handler), (gpointer)gm_data);
    g_debug("done\n");
    printf("done\n");

#endif /* MAEMO5_ENABLED */

    return NULL;
}

#ifdef MAEMO5_ENABLED

static void connection_handler(ConIcConnection *connection,
			       ConIcConnectionEvent *event,
			       gpointer user_data)
{

    ConIcConnectionStatus status = con_ic_connection_event_get_status(event);
    ConIcConnectionError error;
    google_module_data* gm_data;
    gm_data = (google_module_data*)user_data;

    printf("SIGNAL!!!\n");
    switch(status) {
    case CON_IC_STATUS_CONNECTED:
	g_debug("Hey, we are connected\n");
	gm_data->connection_status = 1;
	g_debug("Connection status: OK(status code %d)\n", gm_data->connection_status);
	break;
    case CON_IC_STATUS_DISCONNECTING:
	g_debug("We are disconnecting...\n");
	break;
    case CON_IC_STATUS_DISCONNECTED:
	g_debug("And we are disconnected. Let's see what went wrong...\n");
	gm_data->connection_status = -1;
	g_debug("Connection status: FAIL(status code %d)\n", gm_data->connection_status);
	error = con_ic_connection_event_get_error(event);
	switch(error) {
	case CON_IC_CONNECTION_ERROR_NONE:
	    g_debug("Libconic thinks there was nothing wrong.\n");
	    break;
	case CON_IC_CONNECTION_ERROR_INVALID_IAP:
	    g_debug("Invalid (non-existing?) IAP was requested.\n");
	    break;
	case CON_IC_CONNECTION_ERROR_CONNECTION_FAILED:
	    g_debug("Connection just failed.\n");
	    break;
	case CON_IC_CONNECTION_ERROR_USER_CANCELED:
	    g_debug("User canceled the connection attempt\n");
	    break;
	}
	break;
    default:
	g_debug("Unknown connection status received\n");
    }
}

int connection_wrapper(Kimi* data, GError** error)
{

    gboolean success = FALSE;
    google_module_data* gm_data;

    gm_data = (google_module_data*) kimi_get_module_data(MOD_ID, data, error);

    printf("connecting...\n");

    success = con_ic_connection_connect(gm_data->connection, CON_IC_CONNECT_FLAG_NONE);
    if (!success)
    {
        g_debug("Request for connection failed\n");
        return 1;
    }

    printf("LOOP\n");
    while(gm_data->connection_status == 0){
        g_main_iteration(TRUE);
    }
    printf("LOOP END\n");

    if(gm_data->connection_status == -1){
        printf("we are not connected");
        g_debug("We are not connected");
        return 1;
    }
    
    return NULL;
}
#endif /* MAEMO5_ENABLED */
