#!/bin/sh

# Before use this script:
# 1) Copy this script to another location
# 2) Commit all changes

for tag in $(hg tags | sort -n -k2 | awk '{print $1}'); do
	hg update $tag 2>&1 > /dev/null
	echo $tag:
	for dir in $(find src/ -maxdepth 1 -type d); do
		LOC=$(find $dir -name "*.[hc]" -exec cat {} \;|wc -l)
		echo -e "\t$dir $LOC"
	done
	LOC=$(find src/ -maxdepth 1 -type f -name "*.[hc]" -exec cat {} \; | wc -l)
	echo -e "\tsrc/* files only $LOC"
	echo
done
