#include <windows/callbacks.h>
#include <windows/wevent.h>

#define BUF 50

static void init_wevent_more(GtkWidget* w, AppData* data);
static GtkWidget* create_content_win_more(AppData* data);

static GtkWidget* create_content_win(AppData* data)
{
    GtkWidget* hbox;
    
    GtkWidget* lvbox;
    GtkWidget* rvbox;
    
    GtkWidget* str_box;
    GtkWidget* entry_box;
    GtkWidget* str_hbox;
    
    GtkWidget* date_box;
    GtkWidget* time_box;
    GtkWidget* hdate_box;

    GtkWidget* label_name; 
    GtkWidget* label_location;

    GtkWidget* save_button;
    GtkWidget* more_button;

    guint year;
    guint month;
    guint day;

    hbox      = gtk_hbox_new(FALSE, 0);
    lvbox     = gtk_vbox_new(FALSE, 0);
    rvbox     = gtk_vbox_new(FALSE, 0);
    str_box   = gtk_vbox_new(FALSE, 0);
    str_hbox  = gtk_hbox_new(FALSE, 0);
    entry_box = gtk_vbox_new(FALSE, 0);
    date_box  = gtk_vbox_new(FALSE, 0);
    time_box  = gtk_vbox_new(FALSE, 0);
    hdate_box = gtk_hbox_new(FALSE, 0);

    gtk_kimi_calendar_get_date(data->calendar,
		                       &year,
			                   &month,
			                   &day);

    /* name event */
    label_name = gtk_label_new(_("Name:"));
    data->entry_name = hildon_entry_new(HILDON_SIZE_FINGER_HEIGHT);
    
    gtk_box_pack_start(GTK_BOX(str_box), label_name, TRUE, TRUE, 0);
    gtk_container_add (GTK_CONTAINER (entry_box), GTK_WIDGET(data->entry_name));
    
    /* location */
    label_location = gtk_label_new(_("Location:"));
    data->entry_location = hildon_entry_new(HILDON_SIZE_FINGER_HEIGHT);

    gtk_box_pack_start(GTK_BOX(str_box), label_location, TRUE, TRUE, 0);
    gtk_container_add (GTK_CONTAINER (entry_box), GTK_WIDGET(data->entry_location));

    gtk_box_pack_start(GTK_BOX(str_hbox), str_box, FALSE, FALSE, 0);
    gtk_container_add (GTK_CONTAINER (str_hbox), entry_box);
    gtk_container_add (GTK_CONTAINER (lvbox), str_hbox);
			
    
    /* type event */
    data->button_type = HILDON_PICKER_BUTTON (hildon_picker_button_new (
                                        HILDON_SIZE_FINGER_HEIGHT,
                                        HILDON_BUTTON_ARRANGEMENT_HORIZONTAL));
    hildon_button_set_title (HILDON_BUTTON (data->button_type), _("Type:"));
    HildonTouchSelector *selector_type = HILDON_TOUCH_SELECTOR (hildon_touch_selector_new_text ());
    hildon_picker_button_set_selector (data->button_type, selector_type);
    hildon_touch_selector_append_text (selector_type, _("Meeting"));
    hildon_touch_selector_append_text (selector_type, _("Memo"));
    hildon_picker_button_set_active (data->button_type, 1);
    gtk_container_add (GTK_CONTAINER (lvbox), GTK_WIDGET(data->button_type));
    g_signal_connect(G_OBJECT(data->button_type), "value-changed", G_CALLBACK(changed_event_type), data);
   
    /* Start */
    data->button_start_date = hildon_date_button_new(HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_HORIZONTAL);
    hildon_button_set_title((HildonButton*)data->button_start_date, _("From:"));
    hildon_date_button_set_date(data->button_start_date, year, month, day);
	    
    data->button_start_time = hildon_time_button_new(HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_HORIZONTAL); 
    hildon_button_set_title((HildonButton*)data->button_start_time, "");
    
    gtk_container_add (GTK_CONTAINER (date_box), GTK_WIDGET(data->button_start_date));
    gtk_container_add (GTK_CONTAINER (time_box), GTK_WIDGET(data->button_start_time));

    
    /* End */
    data->button_end_date = hildon_date_button_new(HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_HORIZONTAL);
    hildon_button_set_title((HildonButton*)data->button_end_date, _("To:"));
    hildon_date_button_set_date(data->button_end_date, year, month, day);

    data->button_end_time = hildon_time_button_new(HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_HORIZONTAL);
    hildon_button_set_title((HildonButton*)data->button_end_time, "");
    
    gtk_container_add (GTK_CONTAINER (date_box), GTK_WIDGET(data->button_end_date));
    gtk_container_add (GTK_CONTAINER (time_box), GTK_WIDGET(data->button_end_time));

    gtk_container_add (GTK_CONTAINER (hdate_box), date_box);
    gtk_container_add (GTK_CONTAINER (hdate_box), time_box);
    gtk_container_add (GTK_CONTAINER (lvbox), hdate_box);

    /* disable end date */
    gtk_widget_set_sensitive(GTK_WIDGET(data->button_end_date), FALSE);
    gtk_widget_set_sensitive(GTK_WIDGET(data->button_end_time), FALSE);

    /* storage */
    data->button_storage = HILDON_PICKER_BUTTON (hildon_picker_button_new (
                                        HILDON_SIZE_FINGER_HEIGHT,
                                        HILDON_BUTTON_ARRANGEMENT_HORIZONTAL));
    hildon_button_set_title (HILDON_BUTTON (data->button_storage), _("Storage:"));
    HildonTouchSelector *selector_storage = HILDON_TOUCH_SELECTOR (hildon_touch_selector_new_text ());
    hildon_picker_button_set_selector (data->button_storage, selector_storage);

    GPtrArray* modules = kimi_get_modules(data->kimi);
    int i;
    Module* module;
    for (i = 0; i < modules->len; i++) {
	    module = g_ptr_array_index(modules, i);
        hildon_touch_selector_append_text (selector_storage, module->service_name);
    }

    if(i < data->default_storage){
        hildon_picker_button_set_active(data->button_storage, 0);
    } else {
        hildon_picker_button_set_active(data->button_storage, data->default_storage);
    }

    gtk_container_add (GTK_CONTAINER (lvbox), GTK_WIDGET(data->button_storage));

    /* add button */
    save_button = hildon_button_new_with_text(HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_HORIZONTAL, _("save"), "");
    more_button = hildon_button_new_with_text(HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_HORIZONTAL, _("more"), "");
    g_signal_connect(more_button, "clicked", G_CALLBACK(init_wevent_more), data);
    g_signal_connect(save_button, "clicked", G_CALLBACK(save_event), data);
    
    gtk_box_pack_end(GTK_BOX(rvbox), save_button, FALSE, FALSE, 5);
    gtk_box_pack_end(GTK_BOX(rvbox), more_button, FALSE, FALSE, 5); 
    
    gtk_container_add (GTK_CONTAINER (hbox), lvbox);
    
    gtk_box_pack_start(GTK_BOX(hbox), rvbox, TRUE, TRUE, 6);
   
    return GTK_WIDGET(hbox); 
}

static GtkWidget* create_content_win_more(AppData* data)
{
    GtkWidget* hbox;
    
    GtkWidget* lvbox;
    GtkWidget* rvbox;
    
    GtkWidget* label_description;
   
    GtkWidget* ok_button;
    
    hbox  = gtk_hbox_new(FALSE, 0);
    lvbox = gtk_vbox_new(FALSE, 0);
    rvbox = gtk_vbox_new(FALSE, 0);
    
    /* repeat */
    data->button_repeat = HILDON_PICKER_BUTTON (hildon_picker_button_new (
     			                                            HILDON_SIZE_FINGER_HEIGHT,
          		                                            HILDON_BUTTON_ARRANGEMENT_HORIZONTAL));
    hildon_button_set_title (HILDON_BUTTON (data->button_repeat), _("Repeat:"));
    HildonTouchSelector *selector_type = HILDON_TOUCH_SELECTOR (hildon_touch_selector_new_text ());
    hildon_picker_button_set_selector (data->button_repeat, selector_type);
    hildon_touch_selector_append_text (selector_type, "Unset");
    hildon_touch_selector_append_text (selector_type, "Daily");
    hildon_touch_selector_append_text (selector_type, "Weekdays");
    hildon_touch_selector_append_text (selector_type, "Weekly");
    hildon_touch_selector_append_text (selector_type, "Every two week");
    hildon_touch_selector_append_text (selector_type, "Monthly");
    hildon_touch_selector_append_text (selector_type, "Yearly");
    hildon_picker_button_set_active (data->button_repeat, data->num_repeat);
    gtk_box_pack_start(GTK_BOX(lvbox), GTK_WIDGET(data->button_repeat), FALSE, FALSE, 0);
    				 
    /* remind */
    data->button_remind = HILDON_PICKER_BUTTON (hildon_picker_button_new (
		                                                    HILDON_SIZE_FINGER_HEIGHT,
		                                                    HILDON_BUTTON_ARRANGEMENT_HORIZONTAL));
    hildon_button_set_title (HILDON_BUTTON (data->button_remind), _("Remind:"));
    HildonTouchSelector *selector_type_remind = HILDON_TOUCH_SELECTOR (hildon_touch_selector_new_text ());
    hildon_picker_button_set_selector (data->button_remind, selector_type_remind);
    hildon_touch_selector_append_text (selector_type_remind, "Unset");
    hildon_touch_selector_append_text (selector_type_remind, "0 min");
    hildon_touch_selector_append_text (selector_type_remind, "5 min");
    hildon_touch_selector_append_text (selector_type_remind, "10 min");
    hildon_touch_selector_append_text (selector_type_remind, "15 min");
    hildon_picker_button_set_active (data->button_remind, data->num_remind);
    gtk_box_pack_start(GTK_BOX(lvbox), GTK_WIDGET(data->button_remind), FALSE, FALSE, 0);
   
    /* Description */
    label_description = gtk_label_new(_("Description:"));
    data->text_view = hildon_text_view_new();

    GtkWidget *buffer = hildon_text_view_get_buffer(data->text_view); 
    gtk_text_buffer_set_text(buffer, "", 0);
    gtk_text_buffer_insert_at_cursor(buffer, data->desc,
				                     strlen(data->desc));
   
    gtk_box_pack_start(GTK_BOX(lvbox), GTK_WIDGET(label_description), FALSE, FALSE, 0); 
    gtk_container_add (GTK_CONTAINER (lvbox), data->text_view);
      
    /* ok button */
    ok_button = hildon_button_new_with_text(HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_HORIZONTAL, _("Ok"), "");
    gtk_box_pack_end(GTK_BOX(rvbox), ok_button, FALSE, FALSE, 5);
    g_signal_connect(ok_button, "clicked", G_CALLBACK(save_event_more), data);
	    
    gtk_container_add (GTK_CONTAINER (hbox), lvbox);
    gtk_box_pack_start(GTK_BOX(hbox), rvbox, TRUE, TRUE, 0); 

    return GTK_WIDGET(hbox);	
}

static void init_wevent_more(GtkWidget* w, AppData* data)
{
    GtkWidget *win;
    GtkWidget *hbox;

    win = hildon_stackable_window_new ();

    hbox = create_content_win_more(data);
    gtk_container_add (GTK_CONTAINER (win), GTK_WIDGET(hbox));
    
    gtk_window_set_title(GTK_WINDOW(win), "");

    gtk_widget_show_all(win);
} 

void init_wevent(GtkWidget* w, AppData* data)
{
    GtkWidget* win;
    GtkWidget* hbox;

    win = hildon_stackable_window_new ();
    hbox = create_content_win(data);
    
    gtk_container_add (GTK_CONTAINER (win), GTK_WIDGET (hbox));

    gtk_window_set_title(GTK_WINDOW(win), "new event");

    gtk_widget_show_all(win);    
}

