/*
 * Copyright (C) 2008-2009 Petrozavodsk State University
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */

/*                                                                                                       
 callback.c                                                                                
 Кодировщик: Цветков Е.М.                                                                                
 Дата последней модификации: 3.09.2009                                                                  
*/
#include <ui/callbacks.h>
#include <ui/interface.h>
#include <ui/gtk_kimi_calendar/gtkkimicalendar.h>

#ifdef TEST
#include "../../test/CTF/src/ctf.h"
CTF_TEST_DATA_FILE_NAME_DECL;
#endif

#define COLOR "#f8a000"
#define BUF 32
#define BOLD 1000
#define SEC_IN_DAY (60*60*24)
#define SEC_IN_HOUR (60*60)
#define SEC_IN_MIN 60

/* box question when leaving */
gboolean question_exit(GtkWidget* w, AppData* data)
{
    GtkWidget* note;
    int i;

    /* dialog */
    note = hildon_note_new_confirmation_with_icon_name(GTK_WINDOW(data->window), _("Do you really want to quit?"), GTK_STOCK_DIALOG_QUESTION);

    i = gtk_dialog_run(GTK_DIALOG(note));

    if (i != GTK_RESPONSE_OK) {
	gtk_widget_destroy(GTK_WIDGET(note));
        return TRUE;
    }

    gtk_widget_destroy(GTK_WIDGET(note));
    gtk_main_quit();
    return FALSE;
}


void search(GtkWidget* w, AppData* data)
{
    GtkWidget* widget;
    GtkTreeModel* model;
    const char* buf;
    const char* widget_name = gtk_widget_get_name(w);
    date_id_list* id_list = data->id_list;
    struct tm* tmp;
    date_id_list day_id_list[2];
	day_id_list[1].date = day_id_list[0].date = -1;
    int i;
    guint year;
    guint month;
    guint day;

    /* Get period from cal */
    gtk_kimi_calendar_get_date(GTK_KIMI_CALENDAR(data->ui_data->cal), &year, &month, &day);

    /* if widget_name == day_button_search, then get text from day_field_search */
    if (strcmp(widget_name, "day_button_search") == 0) {
	widget = get_widget("day_field_search", data);
	buf = gtk_entry_get_text(GTK_ENTRY(widget));

        /* new id_list day */
	for (i = 0; id_list[i].date > 0; i++) {
	    tmp = localtime(&id_list[i].date);

	    if (tmp->tm_mday == day) {
		day_id_list[0].date = id_list[i].date;
		day_id_list[0].ids = id_list[i].ids;
		day_id_list[0].ids_size = id_list[i].ids_size;
		break;
	    }
	}
	/* create model tree for this box */
	model = new_model_search_events(buf, data, day_id_list);
    } else {
	if (strcmp(widget_name, "calendar_button_search") == 0) {
	    widget = get_widget("calendar_field_search", data);
	    buf = gtk_entry_get_text(GTK_ENTRY(widget));

	    /* create model tree for this box */
	    model = new_model_search_events(buf, data, data->id_list);
	}
    }

    if (data->ui_data->ev_search_tree_view != NULL) {
	gtk_widget_destroy(GTK_WIDGET(data->ui_data->ev_search_tree_view));
    }

    /* create treeview */
    data->ui_data->ev_search_tree_view = create_view();

    /* set model to TreeView */
    gtk_tree_view_set_model(GTK_TREE_VIEW(data->ui_data->ev_search_tree_view),
                            model);
    g_object_unref(model);

    /* add view in the box */
    w = get_widget("result_search_scrolled_window", data);
    gtk_container_add(GTK_CONTAINER(w), data->ui_data->ev_search_tree_view);

    show_window("result_search", data);
    toolbar_add_bt("result_search", data);

    /* set title */
    gtk_window_set_title(GTK_WINDOW(data->window), _("search"));
}

void date_changed(GtkWidget* w, AppData* data)
{
    guint year;
    guint month;
    guint day;
    time_t start;
    time_t end;
    struct tm tmp;
    struct tm *tmp2;
    int i;
    char buf_date[BUF];
    struct tm cal_date;

#ifndef TEST
    /* delete all marks */
    gtk_kimi_calendar_clear_marks(GTK_KIMI_CALENDAR(data->ui_data->cal));

    /* Get period from cal */ 
    gtk_kimi_calendar_get_date(GTK_KIMI_CALENDAR(data->ui_data->cal), &year, &month, &day);
#else
    day = atoi(CTF_TEST_DATA("KIMI_TEST_DATE_CHANGED_DAY"));
    month = atoi(CTF_TEST_DATA("KIMI_TEST_DATE_CHANGED_MONTH"));
    year = atoi(CTF_TEST_DATA("KIMI_TEST_DATE_CHANGED_YEAR"));
#endif
    cal_date.tm_sec = 0;             /* seconds */
    cal_date.tm_min = 0;             /* minutes */
    cal_date.tm_hour = 0;            /* hours */
    cal_date.tm_mday = day;          /* day of the month */
    cal_date.tm_mon = month;         /* month */
    cal_date.tm_year = year - 1900;  /* year */

    strftime(buf_date, sizeof buf_date, "%B %Y", &cal_date);
#ifndef TEST
    hildon_button_set_value(data->ui_data->select_date_calendar, buf_date);
#endif 
    tmp.tm_sec = 0;		/* seconds */
    tmp.tm_min = 0;		/* minutes */
    tmp.tm_hour = 0;		/* hours */
    tmp.tm_mday = 1;		/* day of the month */
    tmp.tm_mon = month;		/* month */
    tmp.tm_year = year - 1900;	/* year */

    start = mktime(&tmp);

    tmp.tm_sec -= 1;
    tmp.tm_min = 0;
    tmp.tm_hour = 0;
    tmp.tm_mday = 1;
    tmp.tm_mon = month + 1;
    tmp.tm_year = year - 1900;

    end = mktime(&tmp);
    /* Highlight dates from id_list */
    ev_db_date_id_list_free(data);
    ev_sel_get_by_period(start, end, data, NULL);

    date_id_list* id_list = data->id_list;

    for (i = 0; id_list[i].date > 0; i++) {
	tmp2 = localtime(&id_list[i].date);
#ifndef TEST
	gtk_kimi_calendar_mark_day(GTK_KIMI_CALENDAR(data->ui_data->cal), tmp2->tm_mday);

#endif
    }
}

void show_calendar(GtkWidget* w, AppData* data)
{
    date_changed(w, data);
    show_window("calendar", data);

    /* set title */
    gtk_window_set_title(GTK_WINDOW(data->window), _("calendar"));

    toolbar_add_bt("calendar", data);
}

void show_settings(GtkWidget* w, AppData* data)
{
    show_window("settings", data);
    toolbar_add_bt("settings", data);

    /* set title */
    gtk_window_set_title(GTK_WINDOW(data->window), _("settings"));
}

void show_import_events(GtkWidget* w, AppData* data)
{ 
    GtkTreeModel* model;

    /* create model tree for this box */
    model = new_model_import_events(data);

    if(model == NULL) {
	return;
    }

    if (data->ui_data->ev_import_tree_view != NULL) {
        gtk_widget_destroy(GTK_WIDGET(data->ui_data->ev_import_tree_view));
    }

    /* create treeview */
    data->ui_data->ev_import_tree_view = new_view_import_events(model);

    /* set model to TreeView */
    gtk_tree_view_set_model(GTK_TREE_VIEW(data->ui_data->ev_import_tree_view),
                            model);
    g_object_unref(model);

    /* add view in the box */
    w = get_widget("import_events_scrolled_window", data);
    gtk_container_add(GTK_CONTAINER(w), data->ui_data->ev_import_tree_view);

    show_window("import_events", data);
    toolbar_add_bt("import_events", data);

    /* set title */
    gtk_window_set_title(GTK_WINDOW(data->window), _("import events"));
}

void show_event_new(GtkWidget* w, AppData* data)
{
    GtkTextBuffer* text_buffer;
    GtkWidget* widget;
    int day;
    int month;
    int year;

    show_window("event_edit", data);

    /* set title */
    gtk_window_set_title(GTK_WINDOW(data->window), _("event new"));

    /* set this id */
    data->id_current_ev = 0;

    /* clean title */
    widget = get_widget("event_edit_name", data);
    gtk_entry_set_text(GTK_ENTRY(widget), "");

    /* clean location */
    widget = get_widget("event_edit_location", data);
    gtk_entry_set_text(GTK_ENTRY(widget), "");

    gtk_kimi_calendar_get_date(GTK_KIMI_CALENDAR(data->ui_data->cal), &year, &month, &day);

    /* default date start */
    g_debug("%d %d %d", year, month, day);
    hildon_date_button_set_date(data->ui_data->start_date_editor, year, month, day);

    /* default time start */
    hildon_time_button_set_time(data->ui_data->start_time_editor, 0,0);

    /* default date end */
    hildon_date_button_set_date(data->ui_data->end_date_editor, year, month, day);

    /* default time end */
    hildon_time_button_set_time(data->ui_data->end_time_editor, 0,1);

    /* set event type - memo */
    widget = get_widget("event_edit_combobox_type", data);
    gtk_combo_box_set_active(GTK_COMBO_BOX(widget), 0);

    /* set event repeat - unset */
    widget = get_widget("event_edit_combobox_repeat", data);
    gtk_combo_box_set_active(GTK_COMBO_BOX(widget), 0);

    /* off date_end */
    widget = get_widget("event_edit_box_date_end", data);
    gtk_widget_set_sensitive(GTK_WIDGET(widget), FALSE);

    /* off time_end */
    widget = get_widget("event_edit_box_time_end", data);
    gtk_widget_set_sensitive(GTK_WIDGET(widget), FALSE);

    /* set spin  - 0 */
    widget = get_widget("event_edit_spin_reminder", data);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(widget), 0);

    /* set remind - unset */
    widget = get_widget("event_edit_combobox_reminder", data);
    gtk_combo_box_set_active(GTK_COMBO_BOX(widget), 0);

    /* clean description */
    widget = get_widget("event_edit_textview", data);
    text_buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(widget));
    gtk_text_buffer_set_text(text_buffer, "", 0);

    toolbar_add_bt("event_new", data);
}

void show_event_edit(GtkWidget* w, AppData* data)
{
    event* ev;
    GtkWidget* widget;
    GtkSpinButton* spin;
    GtkTextBuffer* text_buffer;
    struct tm* tmp;
    int repeat_type = 0;
    GError* Error = NULL;
    GtkWidget* banner;

    if (w == data->ui_data->tb_ev_edit) {
        data->id_current_ev = get_n_str(GTK_TREE_VIEW(data->ui_data->ev_tree_view));
    }

    /* no selected event */
    if (data->id_current_ev == (guint)-1) {
	return;
    }

    show_window("event_edit", data);

    /* set title */
    gtk_window_set_title(GTK_WINDOW(data->window), _("event edit"));

    /* get event and set filds in the box */
    ev = ev_mgr_new(&Error);
    if (Error != NULL) {
        banner = hildon_banner_show_information(data->ui_data->current,
                                                GTK_STOCK_DIALOG_ERROR,
                                                _("Kimi: Error! Not enoght memory"));
      g_error_free(Error);
      Error = NULL;
      return;
    }

    if (ev_sel_get_by_id(data->id_current_ev, ev, data, &Error) != 0) {
	banner = hildon_banner_show_information(data->ui_data->current,
                                                GTK_STOCK_DIALOG_ERROR,
                                                _("Kimi: Data base error!"));
	return;
    }

    /* name event */
    widget = get_widget("event_edit_name", data);
    gtk_entry_set_text(GTK_ENTRY(widget), ev->title);

    /* location */
    widget = get_widget("event_edit_location", data);
    gtk_entry_set_text(GTK_ENTRY(widget), ev->location);

    /* type */
    widget = get_widget("event_edit_combobox_type", data);
    gtk_combo_box_set_active(GTK_COMBO_BOX(widget), ev->id_type);

    /* Repeat */
    repeat_type = ev_mgr_period_to_rt(ev);
    widget = get_widget("event_edit_combobox_repeat", data);
    gtk_combo_box_set_active(GTK_COMBO_BOX(widget), repeat_type);

    if (ev->id_type == 0) {
        /* off date_end */
	widget = get_widget("event_edit_box_date_end", data);
	gtk_widget_set_sensitive(GTK_WIDGET(widget), FALSE);

        /* off time_end */
	widget = get_widget("event_edit_box_time_end", data);
	gtk_widget_set_sensitive(GTK_WIDGET(widget), FALSE);
    } else {
        /* date end */
	tmp = localtime(&ev->end_time);

	hildon_date_button_set_date(data->ui_data->end_date_editor, tmp->tm_year + 1900, tmp->tm_mon, tmp->tm_mday);
	hildon_time_button_set_time(data->ui_data->end_time_editor, tmp->tm_hour, tmp->tm_min);
    }

    /* date start */
    tmp = localtime(&ev->start_time);

    hildon_date_button_set_date(data->ui_data->start_date_editor, tmp->tm_year + 1900, tmp->tm_mon, tmp->tm_mday);
    hildon_time_button_set_time(data->ui_data->start_time_editor, tmp->tm_hour, tmp->tm_min);

    /* remind */
    spin = (GtkSpinButton*)get_widget("event_edit_spin_reminder", data);
    widget = get_widget("event_edit_combobox_reminder", data);

    if (ev->remind == 0) {
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(spin), 0);
	gtk_combo_box_set_active(GTK_COMBO_BOX(widget), UNSET);
    } else {
	if (ev->remind/(SEC_IN_DAY) > 0) {
	    gtk_spin_button_set_value(GTK_SPIN_BUTTON(spin), (double)ev->remind/(SEC_IN_DAY));
	    gtk_combo_box_set_active(GTK_COMBO_BOX(widget), DAY);
	} else {
	    if (ev->remind/(SEC_IN_HOUR) !=0 ) {
		gtk_spin_button_set_value(GTK_SPIN_BUTTON(spin), (double)ev->remind/(SEC_IN_HOUR));
		gtk_combo_box_set_active(GTK_COMBO_BOX(widget), HOUR);
	    } else {
		if (ev->remind/(SEC_IN_MIN) != 0) {
		    gtk_spin_button_set_value(GTK_SPIN_BUTTON(spin), (double)ev->remind/(SEC_IN_MIN));
		    gtk_combo_box_set_active(GTK_COMBO_BOX(widget), MINUTE);
		}
	    }
	}
    }

    /* description */
    widget = get_widget("event_edit_textview", data);
    text_buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(widget));
    
    gtk_text_buffer_set_text(text_buffer, "", 0);
    gtk_text_buffer_insert_at_cursor(text_buffer, ev->description,
				     strlen(ev->description));

    ev_mgr_clear(ev, NULL);

    toolbar_add_bt("event_edit", data);
}

void event_edit_set_reminder(GtkWidget* w, AppData* data)
{
    GtkWidget* widget;
    int id_type;

    id_type = gtk_combo_box_get_active(GTK_COMBO_BOX(w));

    if (id_type == 0) {
	widget = get_widget("event_edit_spin_reminder", data);
	gtk_widget_set_sensitive(GTK_WIDGET(widget), FALSE);
    } else {
	widget = get_widget("event_edit_spin_reminder", data);
        gtk_widget_set_sensitive(GTK_WIDGET(widget), TRUE);
    }
}

void ev_changed_type(GtkWidget* w, AppData* data)
{
    GtkWidget* widget;
    int id_type;

    /* type */
    id_type = gtk_combo_box_get_active(GTK_COMBO_BOX(w));

    if (id_type == 0) {
	/* off date_end */
	widget = get_widget("event_edit_box_date_end", data);
	gtk_widget_set_sensitive(GTK_WIDGET(widget), FALSE);

        /* off time_end */
	widget = get_widget("event_edit_box_time_end", data);
	gtk_widget_set_sensitive(GTK_WIDGET(widget), FALSE);

	widget = get_widget("label_end", data);
	gtk_widget_set_sensitive(GTK_WIDGET(widget), FALSE);
    } else {
	/* on date_end */
	widget = get_widget("event_edit_box_date_end", data);
	gtk_widget_set_sensitive(GTK_WIDGET(widget), TRUE);

	/* on time_end */
	widget = get_widget("event_edit_box_time_end", data);
	gtk_widget_set_sensitive(GTK_WIDGET(widget), TRUE);

	widget = get_widget("label_end", data);
	gtk_widget_set_sensitive(GTK_WIDGET(widget), TRUE);
    }
}

void show_day(GtkWidget* w, AppData* data)
{
    GtkWidget* day_label_date;
    guint year;
    guint month;
    guint day;
    char buf_date[BUF];
    char buf_name_day[BUF];
    struct timeval t;
    struct tm* date;
    struct tm cal_date;
    time_t time;
    GtkTreeModel* model;

    if (w != GTK_WIDGET(data->ui_data->tb_today)) {
	gtk_kimi_calendar_get_date(GTK_KIMI_CALENDAR(data->ui_data->cal), &year, &month, &day);

	cal_date.tm_sec = 0;	         /* seconds */
	cal_date.tm_min = 0;	         /* minutes */
	cal_date.tm_hour = 0;	         /* hours */
	cal_date.tm_mday = day;	         /* day of the month */
	cal_date.tm_mon = month;	 /* month */
	cal_date.tm_year = year - 1900;	 /* year */

	time = mktime(&cal_date);
	date = localtime(&time);
    } else {
	/* get date today and write in buf */
	gettimeofday(&t, NULL);
	date = localtime((time_t *) (&(t.tv_sec)));

	day = date->tm_mday;

	/* calendar select today */
	gtk_kimi_calendar_select_month(GTK_KIMI_CALENDAR(data->ui_data->cal),
				  date->tm_mon,
				  date->tm_year + 1900);

	gtk_kimi_calendar_select_day(GTK_KIMI_CALENDAR(data->ui_data->cal), day);
    }

    strftime(buf_date, sizeof buf_date, "%d/%m/%y", date);
    strftime(buf_name_day, sizeof buf_name_day, "%A", date);

    day_label_date = get_widget("day_label_date", data);
    gtk_label_set_text(GTK_LABEL(day_label_date), buf_date);

    day_label_date = get_widget("day_label_day", data);
    gtk_label_set_text(GTK_LABEL(day_label_date), buf_name_day);

    /* create model using events */
    model = create_and_fill_model(day, data);

    if (model == NULL) {
	return;
    }

    if (data->ui_data->ev_tree_view != NULL) {
	gtk_widget_destroy(GTK_WIDGET(data->ui_data->ev_tree_view));
    }
    data->ui_data->ev_tree_view = create_view();

    /* set model to TreeView */
    gtk_tree_view_set_model(GTK_TREE_VIEW(data->ui_data->ev_tree_view),
			    model);
    g_object_unref(model);

    w = get_widget("day_scrolled_window", data);
    gtk_container_add(GTK_CONTAINER(w), data->ui_data->ev_tree_view);

    show_window("day", data);

    toolbar_add_bt("day", data);

    /* set title */
    gtk_window_set_title(GTK_WINDOW(data->window), _("day"));
}

static GtkTreeModel* new_model_search_events(const char* filter, AppData* data, date_id_list* id_list)
{
    GtkTreeStore* store;
    GPtrArray* array;
    GtkTreeIter iter;
    event* ev;
    struct tm* tmp;
    char buf[BUF];
    int i;

    array = ev_sel_filter(data, id_list, filter, NULL);

    store = gtk_tree_store_new(3,
                               G_TYPE_STRING,
                               G_TYPE_STRING,
                               G_TYPE_INT);

    for (i = 0; i < array->len; i++) {
	ev = g_ptr_array_index(array, i);

	tmp = localtime(&ev->start_time);
	strftime(buf, sizeof buf, "%d/%m/%y %H:%M", tmp);

	gtk_tree_store_append(store, &iter, NULL);
	gtk_tree_store_set(store, &iter,
			   0, buf, 1, ev->title, 2, ev->id, -1);
    }

    /* free */
    ev_sel_event_array_free(array);

    return GTK_TREE_MODEL(store);
}

static GtkTreeModel* create_and_fill_model(int day, AppData* data)
{
    GtkTreeStore* store;
    GtkTreeIter iter;
    int i, j;
    date_id_list* id_list;
    int* arr;
    struct tm* tmp;
    char buf[BUF];
    event* ev;
    GError* Error = NULL;
    GtkWidget* banner;

    id_list = data->id_list;

    store = gtk_tree_store_new(4,
			       G_TYPE_STRING,
			       G_TYPE_STRING,
			       G_TYPE_INT,
			       G_TYPE_STRING);

    for (i = 0; id_list[i].date > 0; i++) {
	tmp = localtime(&id_list[i].date);

	if (tmp->tm_mday == day) {
	    arr = id_list[i].ids;
	    for (j = 0; j < id_list[i].ids_size; j++) {
                /* get event on id */
		ev = ev_mgr_new(&Error);
		if (Error != NULL) {
		    banner = hildon_banner_show_information(data->ui_data->current,
							    GTK_STOCK_DIALOG_ERROR,
							    _("Kimi: Error! Not enoght memory"));
		    g_error_free(Error);
		    Error = NULL;
		    return NULL;
		}

		if (ev_sel_get_by_id(arr[j], ev, data, &Error) != 0) {
		    banner = hildon_banner_show_information(data->ui_data->current,
							    GTK_STOCK_DIALOG_ERROR,
							    _("Kimi: Data base error!"));
		    return NULL;
		}

		tmp = localtime(&ev->start_time);
		strftime(buf, sizeof buf, "%H:%M", tmp);

		gtk_tree_store_append(store, &iter, NULL);
		gtk_tree_store_set(store, &iter,
				   0, buf, 1, ev->title, 2, arr[j], 3, "green", -1);

                /* free ev */
		ev_mgr_clear(ev, NULL);
	    }
	    break;
	}
    }
    return GTK_TREE_MODEL(store);
}

static GtkTreeModel* new_model_import_events(AppData* data)
{
    GtkTreeStore* store;
    GtkTreeIter iter;
    struct tm* tmp;
    char buf[BUF];
    int i;
    gboolean backlight;
    int weight;
    event* ev;
    GError* Error = NULL;
    GtkWidget* banner;

    /* clean */
    i = 0;
    if (data->google_events != NULL) {
        while (data->google_events[i] != NULL) {
            ev_mgr_clear(data->google_events[i], NULL);
            i++;
	}
        g_free(data->google_events);
    }

    data->google_events = ev_rcv_event_download(GOOGLE_CALENDAR, data, &Error);

    if (Error != NULL) {
	if (Error->code == DOWNLOAD_ERROR_CODE) {
	    banner = hildon_banner_show_information(data->ui_data->current,
						    GTK_STOCK_DIALOG_ERROR,
						    _("Kimi: Error! Problem with google"));
	} else {
	    banner = hildon_banner_show_information(data->ui_data->current,
						    GTK_STOCK_DIALOG_ERROR,
						    _("Kimi: Authentication error!"));
	}

	g_error_free(Error);
	return NULL;
    }

    store = gtk_tree_store_new(7,
			       G_TYPE_BOOLEAN,
                               G_TYPE_STRING,
                               G_TYPE_STRING,
                               G_TYPE_INT,
                               G_TYPE_STRING,
                               G_TYPE_BOOLEAN,
			       G_TYPE_INT);

    i = 0;
    if (data->google_events != NULL) {
        while (data->google_events[i] != NULL) {
	    gtk_tree_store_append(store, &iter, NULL);
	    
	    tmp = localtime(&data->google_events[i]->start_time);
	    strftime(buf, sizeof buf, "%d/%m/%y %H:%M", tmp);
	    
        /* looking at the db of such an event */
	    ev = ev_sel_search_by_field(F_SERVICE_ID, data->google_events[i]->service_event_id, data, NULL);

	    if (ev != NULL) {
		weight = BOLD;
		backlight = TRUE;
	    } else {
		backlight = FALSE;
		weight = 0;
	    }
	    
	    if (ev != NULL)
		ev_mgr_clear(ev, NULL);
	    
	    gtk_tree_store_set(store, &iter,
			       0, !backlight, 1, buf, 2, data->google_events[i]->title, 3, i, 4, COLOR, 5, backlight, 6, weight, -1);
	    i++;  
	}
    }
    return GTK_TREE_MODEL(store);
}

static GtkWidget* create_view()
{
    GtkCellRenderer* renderer;
    GtkWidget* view;

    view = hildon_gtk_tree_view_new(HILDON_UI_MODE_NORMAL);

    /* --- Column #1 --- */
    renderer = gtk_cell_renderer_text_new();
    gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(view),
						-1,
						_("Time"),
						renderer,
						"text", 0, NULL);

    /* --- Column #2 --- */
    renderer = gtk_cell_renderer_text_new();
    gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(view),
						-1,
						_("Event name"),
						renderer, "text", 1, NULL);

    /* show headers */
    gtk_tree_view_set_headers_visible(GTK_TREE_VIEW(view), TRUE);

    return view;
}

static GtkWidget* new_view_import_events(GtkTreeModel* model)
{
    GtkCellRenderer* renderer;
    GtkWidget* view;
    GtkTreeViewColumn* column;
    int column_number;

    view = hildon_gtk_tree_view_new(HILDON_UI_MODE_NORMAL);

    /* --- Column #1 --- */
    renderer = gtk_cell_renderer_toggle_new();

    g_signal_connect (renderer, "toggled",
		      G_CALLBACK (fixed_toggled), model);

    gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(view),
                                                -1,
                                                _(" "),
                                                renderer, "active", 0,
                                                "cell-background-set", 5,
                                                "cell-background", 4,
						NULL);

    /* --- Column #2 --- */
    renderer = gtk_cell_renderer_text_new();
    column = gtk_tree_view_column_new_with_attributes(_("Date event"),
						      renderer,
						      "text", 1,
						      "cell-background-set", 5,
						      "weight", 6,
						      "cell-background", 4,
						      NULL);

    column_number = gtk_tree_view_insert_column(GTK_TREE_VIEW(view), column, -1);
    gtk_tree_view_column_set_sort_column_id(column, column_number-1); /* this column is sorted */

    /* --- Column #3 --- */
    renderer = gtk_cell_renderer_text_new();
    column = gtk_tree_view_column_new_with_attributes(_("Title"),
                                                      renderer,
                                                      "text", 2,
                                                      "cell-background-set", 5,
                                                      "weight", 6,
                                                      "cell-background", 4,
                                                      NULL);

    column_number = gtk_tree_view_insert_column(GTK_TREE_VIEW(view), column, -1);
    gtk_tree_view_column_set_sort_column_id(column, column_number-1);/* this column is sorted */

    /* show headers */
    gtk_tree_view_set_headers_visible(GTK_TREE_VIEW(view), TRUE);

    return view;
}

static void fixed_toggled(GtkCellRendererToggle* cell, gchar* path_str, gpointer data)
{
    GtkTreeModel* model = (GtkTreeModel *)data;
    GtkTreeIter  iter;
    GtkTreePath* path = gtk_tree_path_new_from_string(path_str);
    gboolean fixed;

    /* get toggled iter */
    gtk_tree_model_get_iter(model, &iter, path);
    gtk_tree_model_get(model, &iter, 0, &fixed, -1);

    /* do something with the value */
    fixed ^= 1;

    /* set new value */
    gtk_tree_store_set(GTK_TREE_STORE(model), &iter, 0, fixed, -1);

    /* clean up */
    gtk_tree_path_free(path);
}

static void ev_import_check_all(GtkWidget* w, gpointer user_data)
{
    GtkTreeIter iter;
    GtkTreeModel* model;
    gboolean fixed;
    AppData* data = (AppData *)user_data;
    gboolean valid;
    const char* widget_name;

    widget_name = gtk_widget_get_name(w);

    if (strcmp(widget_name, "check") == 0) {
	fixed = 1;
    } else {
	fixed = 0;
    }

    model = gtk_tree_view_get_model(GTK_TREE_VIEW(data->ui_data->ev_import_tree_view));

    /* get first iter */
    valid = gtk_tree_model_get_iter_first(GTK_TREE_MODEL(model), &iter);

    while (valid) {
        /* set new value */
        gtk_tree_store_set(GTK_TREE_STORE(model), &iter, 0, fixed, -1);
        /* next */
        valid = gtk_tree_model_iter_next(GTK_TREE_MODEL(model), &iter);
    }
}

/* get id selected event in list */
static guint get_n_str(GtkTreeView* tree_view)
{
    GtkTreeIter iter;
    GtkTreeModel* model;
    GtkTreeSelection* selection;

    model = gtk_tree_view_get_model(tree_view);
    selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(tree_view));

    /* get iter selected string */
    if (gtk_tree_selection_get_selected(selection, NULL, &iter)) {
	guint i;
	GValue val = { 0, };

	/* get value of the third column(Type G_TYPE_INT) in the selected row */
	gtk_tree_model_get_value(model, &iter, 2, &val);
	/* get number of the selected row in the source list(array) for the selected row */
	i = g_value_get_int(&val);
	return i;
    }
    return (guint)-1;
}

void show_window_previous(GtkWidget* w, AppData* data)
{
    const gchar* widget_name;

    widget_name = gtk_widget_get_name(data->ui_data->current);

    if (strcmp(widget_name, "event_edit") == 0) {
	show_day(w, data);
	return;
    }

    if (strcmp(widget_name, "settings") == 0) {
	change_windows(data->ui_data->previous_settings, data);
    } else {
	change_windows(data->ui_data->previous, data);
    }

    toolbar_add_bt(NULL, data);
}

static void toolbar_add_bt(const char* widget_name, AppData* data)
{
    GtkToolItem* tb_ev_del;
    GtkToolItem* tb_ev_save;
    GtkToolItem* tb_cancel;
    GtkToolItem* tb_ev_back;
    GtkToolItem* tb_ev_next;
    GtkToolItem* tb_settings_save;

    GtkWidget* icon_check;
    GtkWidget* icon_uncheck;

    GtkToolItem* tb_check_all;
    GtkToolItem* tb_uncheck_all;

    GtkToolItem* tb_ev_upload;
    const char* name;

    if (widget_name == NULL) {
	widget_name = gtk_widget_get_name(GTK_WIDGET(data->ui_data->current));
    }

    if (strcmp(widget_name, "calendar") == 0) {
        data->ui_data->tb_ev_edit = gtk_tool_button_new(gtk_image_new_from_stock(GTK_STOCK_INDEX, HILDON_ICON_PIXEL_SIZE_TOOLBAR), "Select");

        gtk_toolbar_insert(GTK_TOOLBAR(data->ui_data->toolbar),
                           data->ui_data->tb_ev_edit,
                           -1);

        g_signal_connect(G_OBJECT(data->ui_data->tb_ev_edit), "clicked",
                         GTK_SIGNAL_FUNC(show_day), data);
    }

    if (strcmp(widget_name, "day") == 0) {
	data->ui_data->tb_ev_edit = gtk_tool_button_new(gtk_image_new_from_stock(GTK_STOCK_INDEX, HILDON_ICON_PIXEL_SIZE_TOOLBAR), "Select");
	tb_ev_del = gtk_tool_button_new(gtk_image_new_from_stock(GTK_STOCK_DELETE, HILDON_ICON_PIXEL_SIZE_TOOLBAR), "Del");

	tb_ev_upload = gtk_tool_button_new(gtk_image_new_from_stock(GTK_STOCK_ADD, HILDON_ICON_PIXEL_SIZE_TOOLBAR), "Upload");
	gtk_widget_set_name(GTK_WIDGET(tb_ev_upload), "tb_ev_upload");

        tb_ev_back = gtk_tool_button_new(gtk_image_new_from_stock(GTK_STOCK_GO_BACK, HILDON_ICON_PIXEL_SIZE_TOOLBAR), "Back");
	gtk_widget_set_name(GTK_WIDGET(tb_ev_back), "tb_ev_back");
        tb_ev_next = gtk_tool_button_new(gtk_image_new_from_stock(GTK_STOCK_GO_FORWARD, HILDON_ICON_PIXEL_SIZE_TOOLBAR), "Next");
	gtk_widget_set_name(GTK_WIDGET(tb_ev_next), "tb_ev_next");
	
	gtk_toolbar_insert(GTK_TOOLBAR(data->ui_data->toolbar),
			   data->ui_data->tb_ev_edit,
			   -1);
	gtk_toolbar_insert(GTK_TOOLBAR(data->ui_data->toolbar),
			   tb_ev_del,
			   -1);
        gtk_toolbar_insert(GTK_TOOLBAR(data->ui_data->toolbar),
                           tb_ev_upload,
                           -1);
        gtk_toolbar_insert(GTK_TOOLBAR(data->ui_data->toolbar),
			   tb_ev_back,
			   -1);
        gtk_toolbar_insert(GTK_TOOLBAR(data->ui_data->toolbar),
			   tb_ev_next,
			   -1);

	g_signal_connect(G_OBJECT(data->ui_data->tb_ev_edit), "clicked",
			 G_CALLBACK(show_event_edit), data);

        g_signal_connect(G_OBJECT(tb_ev_upload), "clicked",
                         G_CALLBACK(connection), data);

	g_signal_connect(G_OBJECT(tb_ev_del), "clicked",
                         G_CALLBACK(remove_event), data);

	g_signal_connect(G_OBJECT(tb_ev_back), "clicked",
                         G_CALLBACK(next_day), data);
        g_signal_connect(G_OBJECT(tb_ev_next), "clicked",
                         G_CALLBACK(next_day), data);
    }

    if (strcmp(widget_name, "event_new") == 0) {
	tb_ev_save = gtk_tool_button_new(gtk_image_new_from_stock(GTK_STOCK_SAVE, HILDON_ICON_PIXEL_SIZE_TOOLBAR), "Save");
	tb_cancel = gtk_tool_button_new(gtk_image_new_from_stock(GTK_STOCK_CANCEL, HILDON_ICON_PIXEL_SIZE_TOOLBAR), "Cancel");

	gtk_toolbar_insert(GTK_TOOLBAR(data->ui_data->toolbar),
			   tb_ev_save,
			   -1);
	gtk_toolbar_insert(GTK_TOOLBAR(data->ui_data->toolbar),
			   tb_cancel,
			   -1);

	g_signal_connect(G_OBJECT(tb_ev_save), "clicked",
			 G_CALLBACK(save_event), data);
	g_signal_connect(G_OBJECT(tb_cancel), "clicked",
			 G_CALLBACK(show_window_previous), data);
    }

    if (strcmp(widget_name, "event_edit") == 0) {
	tb_ev_save = gtk_tool_button_new(gtk_image_new_from_stock(GTK_STOCK_SAVE, HILDON_ICON_PIXEL_SIZE_TOOLBAR), "Save");
	tb_ev_del = gtk_tool_button_new(gtk_image_new_from_stock(GTK_STOCK_DELETE, HILDON_ICON_PIXEL_SIZE_TOOLBAR), "Del");
	tb_cancel = gtk_tool_button_new(gtk_image_new_from_stock(GTK_STOCK_CANCEL, HILDON_ICON_PIXEL_SIZE_TOOLBAR), "Cancel");
	tb_ev_back = gtk_tool_button_new(gtk_image_new_from_stock(GTK_STOCK_GO_BACK, HILDON_ICON_PIXEL_SIZE_TOOLBAR), "Back");
	tb_ev_next = gtk_tool_button_new(gtk_image_new_from_stock(GTK_STOCK_GO_FORWARD, HILDON_ICON_PIXEL_SIZE_TOOLBAR), "Next");

	gtk_toolbar_insert(GTK_TOOLBAR(data->ui_data->toolbar),
			   tb_ev_save,
			   -1);
	gtk_toolbar_insert(GTK_TOOLBAR(data->ui_data->toolbar),
			   tb_ev_del,
			   -1);
	gtk_toolbar_insert(GTK_TOOLBAR(data->ui_data->toolbar),
			   tb_ev_back,
			   -1);
	gtk_toolbar_insert(GTK_TOOLBAR(data->ui_data->toolbar),
			   tb_ev_next,
			   -1);
	gtk_toolbar_insert(GTK_TOOLBAR(data->ui_data->toolbar),
			   tb_cancel,
			   -1);

	g_signal_connect(G_OBJECT(tb_ev_back), "clicked",
			 G_CALLBACK(back_event), data);
	g_signal_connect(G_OBJECT(tb_ev_next), "clicked",
			 G_CALLBACK(next_event), data);
	g_signal_connect(G_OBJECT(tb_ev_save), "clicked",
			 G_CALLBACK(save_event), data);
	g_signal_connect(G_OBJECT(tb_cancel), "clicked",
			 G_CALLBACK(show_day), data);
	g_signal_connect(G_OBJECT(tb_ev_del), "clicked",
                         GTK_SIGNAL_FUNC(remove_event), data);
    }

    if (strcmp(widget_name, "settings") == 0) {
	tb_settings_save = gtk_tool_button_new(gtk_image_new_from_stock(GTK_STOCK_SAVE, HILDON_ICON_PIXEL_SIZE_TOOLBAR), "Save");
	tb_cancel = gtk_tool_button_new(gtk_image_new_from_stock(GTK_STOCK_CANCEL, HILDON_ICON_PIXEL_SIZE_TOOLBAR), "Cancel");

	gtk_toolbar_insert(GTK_TOOLBAR(data->ui_data->toolbar),
			   tb_settings_save, -1);

	g_signal_connect(G_OBJECT(tb_settings_save), "clicked",
			 G_CALLBACK(save_settings), data);
    }

    if (strcmp(widget_name, "import_events") == 0) {
	icon_check = gtk_image_new_from_file(CHECK_PIXMAP);
	icon_uncheck = gtk_image_new_from_file(UNCHECK_PIXMAP);

	tb_ev_save = gtk_tool_button_new(gtk_image_new_from_stock(GTK_STOCK_SAVE, HILDON_ICON_PIXEL_SIZE_TOOLBAR), "Save");

	tb_check_all = gtk_tool_button_new(icon_check, "check");
	gtk_widget_set_name(GTK_WIDGET(tb_check_all),"check");

	tb_uncheck_all = gtk_tool_button_new(icon_uncheck, "uncheck");
	gtk_widget_set_name(GTK_WIDGET(tb_uncheck_all),"uncheck");

	gtk_toolbar_insert(GTK_TOOLBAR(data->ui_data->toolbar),
                           tb_check_all, -1);
        gtk_toolbar_insert(GTK_TOOLBAR(data->ui_data->toolbar), tb_uncheck_all,
                           -1);

	gtk_toolbar_insert(GTK_TOOLBAR(data->ui_data->toolbar),
			   tb_ev_save,
			   -1);

	g_signal_connect(G_OBJECT(tb_check_all), "clicked",
                         G_CALLBACK(ev_import_check_all), data);
	g_signal_connect(G_OBJECT(tb_uncheck_all),"clicked",
                         G_CALLBACK(ev_import_check_all), data);
        g_signal_connect(G_OBJECT(tb_ev_save),"clicked",
                         G_CALLBACK(save_import_events), data);
    }

    gtk_widget_show_all(GTK_WIDGET(data->ui_data->toolbar));
}

void save_settings(GtkWidget* w, AppData* data)
{
    gboolean fullscreen;
    GtkWidget* banner;

    //сохранить все настроики из окна settings в KeyFile
    //...

    w = get_widget("settings_check_fullscreen", data);
    fullscreen = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w));

    g_key_file_set_boolean(data->KeyFile,
			   "GUI",
			   "AutoFullScreen",
			   fullscreen);

    conf_save(data);

    banner = hildon_banner_show_information(data->ui_data->cal, GTK_STOCK_INFO,
					    _("Kimi: Preferences have been saved"));
    gtk_widget_show(banner);
}

void window_fullscreen(GtkWidget* w, AppData* data)
{
    if (!data->ui_data->fullscreen) {
	data->ui_data->fullscreen = 1;
	gtk_window_fullscreen(GTK_WINDOW(data->window));
    } else {
	data->ui_data->fullscreen = 0;
	gtk_window_unfullscreen(GTK_WINDOW(data->window));
    }
}

void save_import_events(GtkWidget* w, AppData* data)
{
    GtkWidget* banner;
    GtkTreeIter iter;
    GtkTreeModel* model;
    gboolean fixed;
    gboolean valid;
    int i = 0;
    int num_save = 0;
    event* ev;
    int mass_num;

    model = gtk_tree_view_get_model(GTK_TREE_VIEW(data->ui_data->ev_import_tree_view));

    /* get first iter */
    valid = gtk_tree_model_get_iter_first(GTK_TREE_MODEL(model), &iter);

    while (valid) {
	gtk_tree_model_get(GTK_TREE_MODEL(model), &iter, 0, &fixed, -1);
	gtk_tree_model_get(GTK_TREE_MODEL(model), &iter, 3, &mass_num, -1);
        /* save */
	if (fixed == TRUE) {
	    ev = ev_sel_search_by_field(F_SERVICE_ID ,data->google_events[mass_num]->service_event_id, data, NULL);
	    if (ev != NULL) {
		data->google_events[mass_num]->id = ev->id;
		ev_mgr_clear(ev, NULL);
	    }

	    if (ev_mgr_store(data->google_events[mass_num], data, NULL) != 0) {
		banner = hildon_banner_show_information(data->ui_data->current,
							GTK_STOCK_DIALOG_ERROR,
							_("Kimi: Error! Can't write to the data base"));

	    }
	    num_save++;
	}

        /* next */
	valid = gtk_tree_model_iter_next(GTK_TREE_MODEL(model), &iter);
	i++;
    }

    if (num_save > 0) {
	banner = hildon_banner_show_information(data->ui_data->current,
						GTK_STOCK_INFO,
						_("Kimi: Events saved"));

        /* update calendar */
	date_changed(w, data);
    }
}

void save_event(GtkWidget* w, AppData* data)
{
    event* ev;
    GtkWidget* widget;
    struct tm tmp_date;
    GtkTextIter start;
    GtkTextIter end;
    GtkTextBuffer* text_buffer;
    GtkWidget* banner;
    GtkSpinButton* spin;
    const char* title;
    const char* location;
    int repeat_type;
    GError* Error = NULL;   

    ev = ev_mgr_new(&Error);
    if (Error != NULL) {
        banner = hildon_banner_show_information(data->ui_data->current,
                                                GTK_STOCK_DIALOG_ERROR,
						_("Kimi: Error! Not enoght memory"));
        g_error_free(Error);
        Error = NULL;
	return;
    }

    /* id */
    ev->id = data->id_current_ev;

    /* type */
    widget = get_widget("event_edit_combobox_type", data);
    ev->id_type = gtk_combo_box_get_active(GTK_COMBO_BOX(widget));

    /* location */
    widget = get_widget("event_edit_location", data);
    location = gtk_entry_get_text(GTK_ENTRY(widget));
    ev->location = malloc(sizeof(char) * strlen(location) + 1);
    strcpy(ev->location, location);

    /* title */
    widget = get_widget("event_edit_name", data);
    title = gtk_entry_get_text(GTK_ENTRY(widget));
    if (strlen(title) == 0) {
        banner = hildon_banner_show_information(data->ui_data->current,
                                                GTK_STOCK_DIALOG_WARNING,
                                                _("Kimi: No title"));
        return;
    }
    ev->title = malloc(sizeof(char) * strlen(title) + 1);
    strcpy(ev->title, title);

    /* remind */
    spin = (GtkSpinButton*)get_widget("event_edit_spin_reminder", data);
    gtk_spin_button_update (spin);

    widget = get_widget("event_edit_combobox_reminder", data);

    if (gtk_combo_box_get_active(GTK_COMBO_BOX(widget)) == UNSET) {
        ev->remind = 0;
    } else {
        if (gtk_combo_box_get_active(GTK_COMBO_BOX(widget)) == DAY) {
	    ev->remind = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin)) *SEC_IN_DAY;
        } else {
            if (gtk_combo_box_get_active(GTK_COMBO_BOX(widget)) == HOUR) {
                ev->remind = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin)) *SEC_IN_HOUR;
            } else {
                if (gtk_combo_box_get_active(GTK_COMBO_BOX(widget)) == MINUTE) {
                    ev->remind = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin)) *SEC_IN_MIN;
                }
            }
        }
    }

    /* description */
    widget = get_widget("event_edit_textview", data);

    text_buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(widget));

    gtk_text_buffer_get_start_iter(text_buffer, &start);
    gtk_text_buffer_get_end_iter(text_buffer, &end);

    ev->description = gtk_text_buffer_get_text(text_buffer, &start, &end, FALSE);

    /* date start */
    hildon_date_button_get_date(data->ui_data->start_date_editor, &tmp_date.tm_year, &tmp_date.tm_mon, &tmp_date.tm_mday);

    hildon_time_button_get_time(data->ui_data->start_time_editor, &tmp_date.tm_hour, &tmp_date.tm_min);

    tmp_date.tm_sec = 0;

    tmp_date.tm_isdst = -1;   

    tmp_date.tm_year -= 1900; 

    ev->start_time = mktime(&tmp_date);

    /* date end */
    if (ev->id_type == 1) {
	hildon_date_button_get_date(data->ui_data->end_date_editor, &tmp_date.tm_year, &tmp_date.tm_mon, &tmp_date.tm_mday);

	hildon_time_button_get_time(data->ui_data->end_time_editor, &tmp_date.tm_hour, &tmp_date.tm_min);

        tmp_date.tm_sec = 0;

	tmp_date.tm_isdst = -1;

	tmp_date.tm_year -= 1900;

	ev->end_time = mktime(&tmp_date);

	if (ev->start_time > ev->end_time) {
	    banner =
		hildon_banner_show_information(data->ui_data->current,
					       GTK_STOCK_DIALOG_WARNING,
					       _("Kimi: Start date more than end date"));
	    return;
	}
    }

    /* repeat */
    widget = get_widget("event_edit_combobox_repeat", data);
    repeat_type = gtk_combo_box_get_active(GTK_COMBO_BOX(widget));
    ev_mgr_rt_to_period(repeat_type, ev);
    
    /* save */
    if (ev_mgr_store(ev, data, NULL) != 0) {
	banner = hildon_banner_show_information(data->ui_data->current,
						GTK_STOCK_DIALOG_ERROR,
						_("Kimi: Error! Can't write to the data base"));

    } else {
	banner = hildon_banner_show_information(data->ui_data->current,
						GTK_STOCK_INFO,
						_("Kimi: Event saved"));
    }

    /* update calendar */
    date_changed(w, data);

    /* go to edit this event */
    data->id_current_ev = ev->id;
    show_event_edit(GTK_WIDGET(data->window), data);

    /* clear */
    ev_mgr_clear(ev, NULL);
}

static void next_event(GtkWidget* w, AppData* data)
{
    int i, j;
    date_id_list* id_list;
    int* arr;
    int day, month, year;
    struct tm* tmp;

    id_list = data->id_list;

    gtk_kimi_calendar_get_date(GTK_KIMI_CALENDAR(data->ui_data->cal), &year, &month, &day);

    for (i = 0; id_list[i].date > 0; i++) {
	tmp = localtime(&id_list[i].date);

	if (tmp->tm_mday == day) {
	    arr = id_list[i].ids;
	    for (j = 0; j < id_list[i].ids_size; j++) {
		if (arr[j] == data->id_current_ev) {
		    if (j + 1 < id_list[i].ids_size) {
			data->id_current_ev = arr[j + 1];
			show_event_edit(w, data);
			return;
		    } else {
			return;
		    }
		}
	    }
	    break;
	}
    }
}

static void back_event(GtkWidget* w, AppData* data)
{
    int i, j;
    date_id_list* id_list;
    int* arr;
    int day, month, year;
    struct tm* tmp;

    id_list = data->id_list;

    gtk_kimi_calendar_get_date(GTK_KIMI_CALENDAR(data->ui_data->cal), &year, &month, &day);

    for (i = 0; id_list[i].date > 0; i++) {
	tmp = localtime(&id_list[i].date);

	if (tmp->tm_mday == day) {
	    arr = id_list[i].ids;
	    for (j = 0; j < id_list[i].ids_size; j++) {
		if (arr[j] == data->id_current_ev) {
		    if (j - 1 >= 0) {
			data->id_current_ev = arr[j - 1];
			show_event_edit(w, data);
			return;
		    } else {
			return;
		    }
		}
	    }
	    break;
	}
    }
}


static void next_day(GtkWidget* w, AppData* data)
{
    int day, month, year, max_day;
    const char* widget_name;

    widget_name = gtk_widget_get_name(w);

    gtk_kimi_calendar_get_date(GTK_KIMI_CALENDAR(data->ui_data->cal), &year, &month, &day);

    max_day = g_date_get_days_in_month(month+1, year);

    if (strcmp(widget_name, "tb_ev_next") == 0) {
	if (day < max_day) {
	    day++;
	} else {
	    return;
	}
    } else {
        if(day != 1 ) {
            day--;
        } else {
            return;
        }
    }

    gtk_kimi_calendar_select_day(GTK_KIMI_CALENDAR(data->ui_data->cal), day);

    show_day(w, data);
}


void remove_event(GtkWidget* w, AppData* data)
{
    const char* widget_name;
    GtkWidget* note;
    gint i;
    GtkWidget* banner;

    widget_name = gtk_widget_get_name(data->ui_data->current);

    if (strcmp(widget_name, "day") == 0) {
        data->id_current_ev = get_n_str(GTK_TREE_VIEW(data->ui_data->ev_tree_view));
    }

    /* no selected event */
    if (data->id_current_ev == (guint)-1) {
	g_debug("not wood");
	hildon_play_system_sound(SOUND_WOOD);
	return;
    }

    /* dialog */
    note = hildon_note_new_confirmation_with_icon_name(GTK_WINDOW(data->window),
                                                       _("Delete this event?"),
                                                       GTK_STOCK_DIALOG_QUESTION);
    i = gtk_dialog_run (GTK_DIALOG (note));
    gtk_widget_destroy (GTK_WIDGET (note));

    if (i != GTK_RESPONSE_OK) {
        return;
    }

    /* removed from the database */
    if (ev_mgr_remove(data->id_current_ev, data, NULL) == 0) {
	hildon_banner_show_information(data->ui_data->current,
				       GTK_STOCK_INFO,
				       _("Kimi: Event remove"));
    } else {
	banner = hildon_banner_show_information(data->ui_data->current,
						GTK_STOCK_DIALOG_ERROR,
						_("Kimi: Error! Can't remove this event"));
    }

    data->id_current_ev = (guint)-1;
    date_changed(w, data);
    show_day(w, data);
}

int connection(GtkWidget* w, AppData* data)
{
    gboolean success;
    GtkWidget* banner;
    const char* widget_name;

    widget_name = gtk_widget_get_name(w);

    if (strcmp(widget_name, "tb_ev_upload") == 0) {
	data->con_status_up_down = 1;
    } else {
	data->con_status_up_down = 0;
    }
    
    if (strcmp(widget_name, "item_download_events") == 0) {
	data->con_status_up_down = 0;
    }

    /* Connect signal to receive connection events */
    data->handler = g_signal_connect(G_OBJECT(data->connection), "connection-event",
                               G_CALLBACK(connection_handler), data);
    /* Request connection and check for the result */
    success = con_ic_connection_connect(data->connection, CON_IC_CONNECT_FLAG_NONE);
    if (!success) {
	banner = hildon_banner_show_information(data->ui_data->current,
                                                GTK_STOCK_DIALOG_WARNING,
                                                _("Kimi: Request for connection failed"));
        g_warning("Request for connection failed");
	return (-1);
    }
    return 0;
}

static void connection_handler(ConIcConnection* connection,
                                  ConIcConnectionEvent* event,
                                  gpointer user_data)
{
    ConIcConnectionStatus status = con_ic_connection_event_get_status(event);
    ConIcConnectionError error;
    AppData* data = (AppData *)user_data;

    switch(status) {
        case CON_IC_STATUS_CONNECTED:
	    g_debug("Hey, we are connected");

	    if (data->con_status_up_down == 0) {
		show_import_events(NULL, data);
	    } else {
		event_upload(GTK_WIDGET(data->window), data);
	    }

	    g_signal_handler_disconnect(G_OBJECT(data->connection), data->handler); 
            break;
	case CON_IC_STATUS_DISCONNECTING:
	    hildon_banner_show_information(GTK_WIDGET(data->window), NULL, _("Kimi: Network not available"));
            g_debug("We are disconnecting...");
            break;
        case CON_IC_STATUS_DISCONNECTED:
	    hildon_banner_show_information(GTK_WIDGET(data->window), NULL, _("Kimi: Network not available"));
	    g_debug("And we are disconnected. Let's see what went wrong...");
            error = con_ic_connection_event_get_error(event);

#ifndef CONIC
            if (data->con_status_up_down == 0) {
                show_import_events(NULL, data);
            } else {
                event_upload(GTK_WIDGET(data->window), data);
            }

	    g_signal_handler_disconnect(G_OBJECT(data->connection), data->handler);
#endif

            switch(error) {
                case CON_IC_CONNECTION_ERROR_NONE:
                    g_debug("Libconic thinks there was nothing wrong.");
                    break;
                case CON_IC_CONNECTION_ERROR_INVALID_IAP:
                    g_debug("Invalid (non-existing?) IAP was requested.");
                    break;
                case CON_IC_CONNECTION_ERROR_CONNECTION_FAILED:
                    g_debug("Connection just failed.");
                    break;
                case CON_IC_CONNECTION_ERROR_USER_CANCELED:
                    g_debug("User canceled the connection attempt");
                    break;
            }
            break;
        default:
            g_debug("Unknown connection status received");
    }
}

/* Callback for hardware keys */
gboolean key_press_cb(GtkWidget* widget, GdkEventKey* event, AppData* data)
{
    switch (event->keyval) {
	case HILDON_HARDKEY_UP:
	  /* hildon_banner_show_information(GTK_WIDGET(data->window), NULL, "Navigation Key Up"); */
	    return TRUE;
	case HILDON_HARDKEY_DOWN:
	  /* hildon_banner_show_information(GTK_WIDGET(data->window), NULL, "Navigation Key Down"); */
	    return TRUE;
	case HILDON_HARDKEY_LEFT:
	  /* hildon_banner_show_information(GTK_WIDGET(data->window), NULL, "Navigation Key Left"); */
	    return TRUE;
	case HILDON_HARDKEY_RIGHT:
	  /* hildon_banner_show_information(GTK_WIDGET(data->window), NULL, "Navigation Key Right"); */
	    return TRUE;
	case HILDON_HARDKEY_SELECT:
	  /* hildon_banner_show_information(GTK_WIDGET(data->window), NULL, "Navigation Key select"); */
	    return TRUE;
	case HILDON_HARDKEY_FULLSCREEN:
	    window_fullscreen(widget, data);
	    /* hildon_banner_show_information(GTK_WIDGET(data->window), NULL, "Full screen"); */
	    return TRUE;
	case HILDON_HARDKEY_INCREASE:
	  /* hildon_banner_show_information(GTK_WIDGET(data->window), NULL, "Increase (zoom in)"); */
	    return TRUE;
	case HILDON_HARDKEY_DECREASE:
	  /* hildon_banner_show_information(GTK_WIDGET(data->window), NULL, "Decrease (zoom out)"); */
	    return TRUE;
	case HILDON_HARDKEY_ESC:
	  /* hildon_banner_show_information(GTK_WIDGET(data->window), NULL, "Cancel/Close"); */
	    return TRUE;
    }
    return FALSE;
}

static void event_upload(GtkWidget* w, AppData* data)
{
    guint id;
    GError* Error = NULL;
    GtkWidget* banner;

    id = get_n_str(GTK_TREE_VIEW(data->ui_data->ev_tree_view));

    /* no selected event */
    if (id == (guint)-1) {
	return;
    }

    /* get event and set filds */
    data->ev_upload = ev_mgr_new(&Error);
    if (Error != NULL) {
        banner = hildon_banner_show_information(data->ui_data->current,
                                                GTK_STOCK_DIALOG_ERROR,
                                                _("Kimi: Error! Not enoght memory"));
        g_error_free(Error);
        Error = NULL;
        return;
    }

    if (ev_sel_get_by_id(id, data->ev_upload, data, &Error) != 0) {
	banner = hildon_banner_show_information(data->ui_data->current,
                                                GTK_STOCK_DIALOG_ERROR,
                                                _("Kimi: Data base error!"));
	return;
    }

    if (data->ev_upload != NULL) {
	ev_rcv_event_upload(GOOGLE_CALENDAR, data, &Error);
	if (Error != NULL) {
	    g_debug("ERROR: %d", Error->code);
	    if (Error->code == UPLOAD_ERROR_CODE) {
		banner = hildon_banner_show_information(data->ui_data->current,
							GTK_STOCK_DIALOG_ERROR,
							_("Kimi: Error! Problem with google"));
	    } else {
		banner = hildon_banner_show_information(data->ui_data->current,
							GTK_STOCK_DIALOG_ERROR,
							_("Kimi: Authentication error!"));
	    }

	    g_error_free(Error);
	    return NULL;
	}

        
        /* save */
	if (ev_mgr_store(data->ev_upload, data, NULL) != 0) {
	    banner = hildon_banner_show_information(data->ui_data->current,
						    GTK_STOCK_DIALOG_ERROR,
						    _("Kimi: Error! Can't write to the data base"));
	}

	hildon_banner_show_information(GTK_WIDGET(data->window), NULL, _("Kimi: event uploaded"));
	ev_mgr_clear(data->ev_upload, NULL);
    }
}

int set_login(GtkWidget* w, AppData* data)
{
    HildonLoginDialog* login_dialog;
    gint response;
    const char* username;
    const char* password;
    const char* old_username;
    const char* old_password;
    int resp = 0;

    old_username = g_key_file_get_string(data->KeyFile, "Service", "GoogleLogin", NULL);
    old_password = g_key_file_get_string(data->KeyFile, "Service", "GooglePass", NULL);

    login_dialog = (HildonLoginDialog*)hildon_login_dialog_new_with_default(GTK_WINDOW(data->window), old_username, old_password);
    gtk_window_set_title(GTK_WINDOW(login_dialog), _("Set login"));
    hildon_login_dialog_set_message(login_dialog, _("Enter you Google account information:"));

    response = gtk_dialog_run(GTK_DIALOG(login_dialog));

    if (response == GTK_RESPONSE_OK) {
	username = hildon_login_dialog_get_username(login_dialog);
	password = hildon_login_dialog_get_password(login_dialog);

	g_key_file_set_string(data->KeyFile, "Service", "GoogleLogin", username);
	g_key_file_set_string(data->KeyFile, "Service", "GooglePass", password);

	conf_save(data);

	resp = 1;
    }

    gtk_widget_destroy(GTK_WIDGET(login_dialog));

    return resp;
}

void not_realised_feature(GtkWidget* w, AppData* data)
{
    hildon_banner_show_information(GTK_WIDGET(data->window), NULL, _("Kimi: This feature not implemented yet"));
}

void select_date_dialog(GtkWidget* w, AppData* data)
{
    GtkWidget* dialog;
    GtkWidget* date_selector;
    int result;
    int year;
    int month;
    int day;
    
    date_selector = hildon_date_selector_new();
    gtk_kimi_calendar_get_date(data->ui_data->cal, &year, &month, &day);
    hildon_date_selector_select_current_date(date_selector, year, month, day);

    dialog = hildon_picker_dialog_new(GTK_WIDGET(data->window));
    hildon_picker_dialog_set_selector(dialog, (HildonTouchSelector *)date_selector);
    hildon_picker_dialog_set_done_label(dialog, _("Done"));

    result = gtk_dialog_run(GTK_DIALOG(dialog));

    hildon_date_selector_get_date(date_selector,
		                  &year,
		                  &month,
		                  &day);
       
    gtk_kimi_calendar_select_month(data->ui_data->cal, month, year);
    
    gtk_widget_destroy(GTK_WIDGET(date_selector));
    gtk_widget_destroy(GTK_WIDGET(dialog));    

    date_changed(w, data); 
}

/* help */
void callback_help(GtkWidget* w, AppData* data)
{
    GtkWidget* dialog;
    //GtkWidget* text_view;
    //GtkTextBuffer* text_buffer;
    GtkWidget* label;
    
    dialog = gtk_dialog_new ();
    gtk_window_set_transient_for(GTK_WINDOW (dialog), GTK_WINDOW (data->window));
    gtk_window_set_title (GTK_WINDOW (dialog), _("Help"));

    //text_view = gtk_text_view_new();
    //text_buffer = gtk_text_view_get_buffer(text_view);

    //gtk_text_buffer_set_text(text_buffer, "TEsT", 4);
    //gtk_text_view_set_editable(text_view, FALSE);

    label = gtk_label_new(_("Kimi - the calendaring software for Maemo-based mobile devices.\nKimi can organize events information and gather this information from\nvarious sources. The main goal of the project is to develop an\napplication for simple and convinient management of the user's event\nspace. Also the capability of linking contacts with events is planned."));
    
    gtk_container_add(GTK_CONTAINER(GTK_DIALOG(dialog)->vbox), label);

    /* Ensure that the dialog box is destroyed when the user responds. */
    g_signal_connect_swapped(dialog, "response", G_CALLBACK (gtk_widget_destroy), dialog);

    gtk_widget_show_all (GTK_WIDGET (dialog));

    gtk_dialog_run (GTK_DIALOG (dialog));      
}

