/*
 * Copyright (C) 2008-2009 Petrozavodsk State University
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */
/*
  main
  Кодировщик: Цветков Е.М.
  Дата последней модификации: 2.09.2009
*/

#include <sys/stat.h>
#include <errno.h>
#include <ui/interface.h>
#include <appdata.h>
#include <libalarm.h>
#include <locale.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#define OSSO_SERVICE "ru.karelia.cs."PACKAGE

#define _(String) gettext(String)

#ifdef TEST
#include "../test/CTF/src/ctf.h"
CTF_TEST_DATA_FILE_NAME_DECL;
#endif

time_t gdate2time_t(GDate *d)
{
    struct tm t;
    g_date_to_struct_tm(d, &t);
    t.tm_isdst = 0;
    return mktime(&t);
}

void create_ebook(AppData* data)
{
    GError* error = NULL;
    EBookQuery* query;

    /* Initialise ebook */
    if (!osso_abook_init_with_name ("kimiaddressbookname", data->osso)) {
        g_assert(0);
    }

    data->book = e_book_new_system_addressbook(NULL);
    g_assert(data->book);

    if(!e_book_open(data->book, FALSE, &error))
    {
        g_critical("Couldn't open addressbook: %s", error->message);
        g_error_free(error);
        return;
    }

}


/*
 * create our application specific data
 * This consists of allocating some space
 * for the AppData structure, and also
 * creating the list store that will act
 * as a model for the contact list.
 * The other elements of the AppData structure
 * are implicitly set by the call to g_new0
 * which zeroes the memory of the AppData, thereby
 * setting create_new to FALSE, and iter to NULL.
 *
 */
AppData* create_data()
{
    AppData* result = g_new0(AppData, 1);
#ifndef TEST
    /* init osso */
    result->osso = osso_initialize(OSSO_SERVICE, VERSION, TRUE, NULL);
    g_assert(result->osso);
#endif

    char* path = build_full_path("/");
    int code = mkdir(path, S_IRWXU);
    free(path);
    g_assert(code == 0 || errno == EEXIST);


    /* Address book initialize */
    create_ebook(result);

    /* Database initializing */
    GError* error = NULL;
#ifdef TEST
    path = CTF_TEST_DATA("KIMI_TEST_DEFAULT_DB"); 
#else
    path = build_full_path("db.sqlite");
#endif
    code = ev_db_init(result, path,  &error);
    if(code && error)
    {
        fprintf(stderr, "Error: %s\n", error->message);
        g_error_free(error);
    }
    free(path);


    /* Init ConIcConnection */
    result->connection = con_ic_connection_new();

    return result;
}

/* Here we clean up all the data that we allocated */
void destroy_data(AppData* data)
{
#ifndef TEST
    osso_deinitialize(data->osso);
#endif

    /* destroy ConIcConnection object*/
    g_object_unref(data->connection);

    ev_db_date_id_list_free(data);

    ev_db_close(data, NULL);
    conf_destroy(data);
    g_free(data);
}

#ifndef TEST
int main(int argc, char* argv[])
{
    //int a[2];
    //int b = a[2];
    HildonProgram* program;
    AppData* data;

    /* Initialize the locale stuff */
    setlocale(LC_ALL, "");
    bindtextdomain(GETTEXT_PACKAGE, LOCALEDIR);
    bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
    textdomain(GETTEXT_PACKAGE);

    /* Init the gtk - must be called before any hildon stuff */
    hildon_gtk_init(&argc, &argv);

    /* Create the hildon application and setup the title */
    program = HILDON_PROGRAM(hildon_program_get_instance());
    g_set_application_name("Kimi");

    if(!g_thread_supported()) {
	g_thread_init(NULL);
    }

    /* Create the data and views for our application */
    data = create_data();
    data->program = program;

    conf_init(data);
    interface_initialization(data);

    hildon_program_add_window(data->program, data->window);
    g_signal_connect(G_OBJECT(data->window), "delete-event", G_CALLBACK(question_exit), data);
    gtk_widget_show_all(GTK_WIDGET(data->window));

    show_calendar(GTK_WIDGET(data->window), data);

    //gtk_container_add (GTK_CONTAINER (data->window), data->contact_view);
            /*
    GtkWidget* note = hildon_note_new_information_with_icon_name(data->ui_data->current, "Error!", GTK_STOCK_DIALOG_ERROR);
    //hildon_note_new_confirmation_with_icon_name(data->ui_data->current, "Trial version!", GTK_STOCK_DIALOG_AUTHENTICATION);
    //hildon_note_set_button_texts(note, "Buy now!", "Exit");

    hildon_note_set_button_text(note, "OK");
    gint i = gtk_dialog_run (GTK_DIALOG (note));
    gtk_widget_destroy (GTK_WIDGET (note));

    if (i == GTK_RESPONSE_OK)
    {
	GtkWidget* banner =  hildon_banner_show_information(data->ui_data->cal, GTK_STOCK_DIALOG_ERROR, "Error! License GPL!");
	gtk_widget_show(banner);
    }

    gtk_widget_show(note);
    */
#if 0
    {
        GtkWidget *dialog, *label, *content_area;
        /* Create the widgets */
        dialog = gtk_dialog_new_with_buttons ("Message",
                GTK_WINDOW(data->window),
                GTK_DIALOG_DESTROY_WITH_PARENT,
                GTK_STOCK_OK,
                GTK_RESPONSE_NONE,
                NULL);
        
        content_area = GTK_DIALOG(dialog)->vbox;

        /* Add the label, and show everything we've added to the dialog. */
        gtk_container_add (GTK_CONTAINER (content_area), GTK_WIDGET(data->contact_view));
        gtk_widget_show_all (dialog);

    }
#endif
#if 0

    EBookQuery* qwer = e_book_query_any_field_contains("");
    GList* list = NULL;
    int res = e_book_get_contacts (data->book, qwer, 
                                          &list, NULL);
    size_t size = g_list_length(list);
    int i;
    for (i = 0; i < size; i++)
    {
        EContact* cont = g_list_nth_data(list, i);
        g_debug("%s\n", e_contact_get(cont, E_CONTACT_UID));
    }
#endif

#if 0
    //pas-id-4AB93B1100000000
    EContact* con = NULL;
    e_book_get_contact (data->book, "pas-id-4AB93B1100000000", 
                                         &con, NULL);

    g_debug("%s\n", e_contact_get(con, E_CONTACT_NICKNAME));
#endif

#if 0
    GList* list = ev_get_contacts(1, data);
    int i;
    size_t size = g_list_length(list);
    for (i = 0; i < size; i++)
    {
        EContact* cont = g_list_nth_data(list, i);
        g_debug("%s\n", e_contact_get(cont, E_CONTACT_UID));
    }
#endif

#if 0
    char* uid = NULL;
    GList* l = NULL;
    GList* list = ev_mgr_get_select_contacts();
    for (l = list; l; l = l->next) {
        g_debug("%s\n", uid = ev_mgr_get_contact_id(l->data));


        EBookQuery* query = e_book_query_field_test (E_CONTACT_UID, E_BOOK_QUERY_BEGINS_WITH, uid);
        e_book_get_contacts (data->book, query, &list, NULL);
        
        EContact* cont = list->data;
        uid = e_contact_get(cont, E_CONTACT_UID);

        g_debug("%s\n", uid);


        OssoABookContact* ocont = OSSO_ABOOK_CONTACT(cont);
    }
#endif

#if 0
    //OssoABookAggregator* aggr = osso_abook_aggregator_get_default(NULL);
    int count = osso_abook_aggregator_get_master_contact_count(data->aggr);
    OssoABookContact* cont = osso_abook_aggregator_lookup(data->aggr, "6")->data;
    const char* name = "qwe";//osso_abook_contact_get_display_name(cont);

    g_debug("Test: %d %s\n", count, name);
#endif

#if 0
    ev_mgr_contact_dialog_add(14, data);
#endif
    gtk_main();

    /* Clean up */
    interface_main_view_destroy(data->ui_data);
    destroy_data(data);

    return 0;
}
#endif

char* build_full_path(const char* filename)
{
    char* result = NULL;
    char* home_var = getenv("HOME");
    int len = strlen(home_var) + 1 + \
    strlen(SETTINGS_DIR) + 1 + \
        strlen(filename);

    result = malloc(len + 1);
    snprintf(result, len + 1, "%s/%s/%s", home_var, SETTINGS_DIR, filename);

    return result;
}
