/*
 * Copyright (C) 2008-2009 Petrozavodsk State University
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */
#define CTF_LOG_FORMAT_USE_TIME
#define CTF_THROW_EXIT

#include "events/events.h"
#include "../CTF/src/ctf.h"
#include <ui/callbacks.h>
#include <settings/settings.h>
#include <appdata.h>
#include <time.h>

#define BUF_SIZE 2048

GLOBAL_DECL();
CTF_TEST_DATA_FILE_NAME_DECL;
CTF_STAT_FILE_NAME_DECL;

CTF_TEST_CASE(event_data_access_open_db_with_wrong_filename_test) {
    CTF_TEST_NAME("event_data_access_open_db_with_wrong_filename_test");
    
    AppData app;

    CTF_CHECK(ev_db_init(&app, "/bin/sh", NULL) != 0);
    CTF_CHECK(ev_db_init(&app, "/dev/urandom", NULL) != 0);
}

CTF_TEST_CASE(event_data_access_query_test) {
    CTF_TEST_NAME("event_data_access_query_test");
    srand(time(NULL));
    
    AppData   *data;
    data = create_data();
    conf_init(data);

    ev_db_date_id_list_free(data);
    
    int n;
    int m;
    
    /* No statement passed */
    CTF_CHECK(!ev_db_sql_query_prep_str(NULL, &n, &m, data, NULL, 123, 256, 444, 44545454));
    
    /* Wrong parameters */
    CTF_CHECK(!ev_db_sql_query_prep_str(data->db_data.get_last_id, &n, &m, data, NULL, 100500, 256, 666, 42));
    
    /* No n and m */
    CTF_CHECK(ev_db_sql_query_prep_str(data->db_data.get_last_id, NULL, NULL, data, NULL, DB_INT, 1, DB_END, 42, 100500));

    /* No n and m */
    CTF_CHECK(!ev_db_sql_query_prep_str(data->db_data.get_last_id, NULL, NULL, data, NULL, DB_INT, 1, 26, 42, 100500));

    int i;
    int ok = 1;
    int ok2 = 1;
    
    /* Crazy test */
    for(i = 0; i < 10000; i++) {
        GPtrArray* arr;
        if (arr = ev_db_sql_query_prep_str(data->db_data.get_last_id,
            0, 0, data, NULL, rand(), rand(), rand(), rand(), rand())) {
            ok = 0;
            break;   
        }
        ev_db_sql_query_clear_2(arr, 0);
        
        if (arr = ev_db_sql_query_prep_str(data->db_data.get_period,
            0, 0, data, NULL, rand(), rand(), rand(), rand(), rand())) {
            ok2 = 0;
            break;   
        }
        ev_db_sql_query_clear_2(arr, 0);
    }
    
    CTF_CHECK(ok);
    CTF_CHECK(ok2);
    
    ev_db_date_id_list_free(data);
    destroy_data(data);
}
