/*
 * Copyright (C) 2008-2009 Petrozavodsk State University
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */
#ifndef INTERFACE_H
#define INTERFACE_H

#include <ui/callbacks.h>
#include <remote_storage/remote_storage.h>

#ifndef GLADEFILE
#define GLADEFILE "data/interface.glade"
#endif

#ifndef PIXMAP_PATH
#define PIXMAP_PATH "data/pixmaps"
#endif

#define CALENDAR_PIXMAP PIXMAP_PATH"/40x40/calendar.png"

#define _(String) gettext(String)

void interface_initialization(AppData* data);
void interface_main_view_destroy(AppUIData* main);

GtkWidget* get_widget(const char* name_id, AppData* data);

int change_windows(GtkWidget* widget, AppData* data);
void show_window(const char* name_id, AppData* data);

void init_find_toolbar(AppData* data);

static void init_calendar(AppData* data);
static void init_event_edit(AppData* data);
static void init_event_new(AppData* data);
static void init_import_events(AppData* data);
static void init_settings(AppData* data);
static void init_day(AppData* data);
static void initialization_all_windows(AppData* data);

static void create_menu(AppData* data);
static void create_toolbar(AppData* data);
static void tb_add_main_btns();
#endif
