/*
 * Copyright (C) 2008-2009 Petrozavodsk State University
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */

/*
  GUI
  Кодировщик: Цветков Е.М.
  Дата последней модификации: 2.09.2009
*/

#include <ui/interface.h>

#define BUF 50

/* create and init hildon window */
void interface_initialization(AppData* data)
{
    GtkWidget* window;
    gboolean auto_fullscreen;

    data->ui_data = g_new0(AppUIData, 1);

    /* pointer to the current window */
    data->ui_data->current = NULL;

    /* load the interface from file */
    data->ui_data->xml = NULL;
    data->ui_data->xml = glade_xml_new(GLADEFILE, NULL, NULL);
    g_assert(data->ui_data->xml != NULL);

    window = hildon_window_new();
    data->window = HILDON_WINDOW(window);

    auto_fullscreen = g_key_file_get_boolean(data->KeyFile,
                                             "GUI",
                                             "AutoFullScreen",
                                             NULL);

    if (auto_fullscreen) {
	gtk_window_fullscreen(GTK_WINDOW(data->window));
    } else {
	gtk_window_unfullscreen(GTK_WINDOW(data->window));
    }

    data->ui_data->fullscreen = auto_fullscreen;

    create_menu(data);
    create_toolbar(data);

    initialization_all_windows(data);

    /* Add hardware button listener to application */
    g_signal_connect(G_OBJECT(data->window), "key_press_event", G_CALLBACK(key_press_cb), data);
}

/* displays a new window */
int change_windows(GtkWidget* widget, AppData* data)
{
    GtkWidget* current = data->ui_data->current;
    GtkWidget* parent;

    if (current != NULL) {
	if (strcmp(gtk_widget_get_name(widget), "settings") == 0 || strcmp(gtk_widget_get_name(current), "settings") == 0) {
	    data->ui_data->previous_settings = current;
	} else {
	    data->ui_data->previous = current;
	}
    }

    g_assert(widget != NULL);

    /* remove the parent from the new window */
    parent = gtk_widget_get_parent(widget);
    if (parent != NULL) {
	gtk_widget_ref(widget);
	gtk_container_remove(GTK_CONTAINER(parent), widget);
    }

    /* disable the current window from the main hildon window */
    if (current != NULL && current != widget) {
	gtk_widget_ref(current);
	gtk_container_remove(GTK_CONTAINER(data->window), current);
    }

    /* add a new window */
    gtk_container_add(GTK_CONTAINER(data->window), widget);
    gtk_widget_unref(widget);

    data->ui_data->current = widget;

    /* clear toolbar */
    gtk_container_foreach(GTK_CONTAINER(data->ui_data->toolbar),
			  G_CALLBACK(gtk_widget_destroy), data);

    tb_add_main_btns(data);

    gtk_widget_show_all(GTK_WIDGET(data->window));

    return 0;
}

/* create widget */
GtkWidget* get_widget(const char* name_id, AppData* data)
{
    GtkWidget* widget = NULL;

    widget = glade_xml_get_widget(data->ui_data->xml, name_id);

    return widget;
}

/* initialize window calendar */
static void init_calendar(AppData* data)
{
    GtkWidget* cal_root_widget;
    GtkRcStyle* style;
    struct tm cal_date;
    char buf_date[BUF];
    int day;
    int month;
    int year;
    
    cal_root_widget = get_widget("calendar", data);
    data->ui_data->cal = gtk_kimi_calendar_new();
 
    /* add select date button */   
    data->ui_data->select_date_calendar = hildon_button_new(HILDON_SIZE_AUTO_WIDTH, HILDON_BUTTON_ARRANGEMENT_HORIZONTAL);
    
    gtk_kimi_calendar_get_date(data->ui_data->cal, &year, &month, &day);
    
    cal_date.tm_sec = 0;             /* seconds */
    cal_date.tm_min = 0;             /* minutes */
    cal_date.tm_hour = 0;            /* hours */
    cal_date.tm_mday = day;          /* day of the month */
    cal_date.tm_mon = month;         /* month */
    cal_date.tm_year = year - 1900;  /* year */

    strftime(buf_date, sizeof buf_date, "%B %Y", &cal_date);
  
    hildon_button_set_value(data->ui_data->select_date_calendar, buf_date);
    gtk_box_pack_start(GTK_BOX(cal_root_widget),
		   GTK_WIDGET(data->ui_data->select_date_calendar),
		   TRUE,
		   TRUE,
		   0);
   
    g_signal_connect(G_OBJECT(data->ui_data->select_date_calendar),
		     "clicked",
		     G_CALLBACK(select_date_dialog), data);
    
    /* set style calendar */
    style = gtk_widget_get_modifier_style(GTK_WIDGET(data->ui_data->cal));
    style->xthickness = 0;
    style->ythickness = 0;
    gtk_widget_modify_style(GTK_WIDGET(data->ui_data->cal), style);

    gtk_kimi_calendar_set_display_options(data->ui_data->cal, 2);

    /* add calendar */    
    gtk_box_pack_start(GTK_BOX(cal_root_widget),
		       GTK_WIDGET(data->ui_data->cal),
		       TRUE,
		       TRUE,
		       0);

    g_signal_connect(G_OBJECT(data->ui_data->cal), "next-year",
		     G_CALLBACK(date_changed), data);
    g_signal_connect(G_OBJECT(data->ui_data->cal), "prev-year",
		     G_CALLBACK(date_changed), data);
    g_signal_connect(G_OBJECT(data->ui_data->cal), "next-month",
		     G_CALLBACK(date_changed), data);
    g_signal_connect(G_OBJECT(data->ui_data->cal), "prev-month",
		     G_CALLBACK(date_changed), data);

    g_signal_connect(G_OBJECT(data->ui_data->cal),
		     "day-selected-double-click",
		     G_CALLBACK(show_day), data);

 //   init_find_toolbar(data);
}

void init_find_toolbar(AppData* data)
{
//    GtkListStore *store;
//    GtkTreeIter iter;    

    /* Create and populate history list model */
/*    store = gtk_list_store_new (1, G_TYPE_STRING);
    gtk_list_store_append (store, &iter);
    gtk_list_store_set (store, &iter, 0, "kimi", -1);
    gtk_list_store_append (store, &iter);
    gtk_list_store_set (store, &iter, 0, "maemo", -1);
    gtk_list_store_append (store, &iter);
    gtk_list_store_set (store, &iter, 0, "nokia", -1);
*/
    /* Create find toolbar */
//    data->ui_data->find_toolbar = hildon_find_toolbar_new_with_model ("Find", store, 0);
    data->ui_data->find_toolbar = hildon_find_toolbar_new("Find");
    /* Set item on index 0 as the current active*/
//    hildon_find_toolbar_set_active (HILDON_FIND_TOOLBAR (data->ui_data->find_toolbar), 0);
    /* Attach a callback to handle "history-append" signal */
//    g_signal_connect_after (G_OBJECT (data->ui_data->find_toolbar), "history-append", G_CALLBACK (on_history_append), NULL);
    /* Attach a callback to handle "close" signal */
    g_signal_connect_after(G_OBJECT (data->ui_data->find_toolbar), "close", G_CALLBACK (gtk_widget_destroy), NULL);    
    /* Attach a callback to handle "search" signal */
    g_signal_connect_after(G_OBJECT (data->ui_data->find_toolbar), "search", G_CALLBACK (search), data);
    /* Attach toolbar to window */
    hildon_window_add_toolbar(HILDON_WINDOW(data->window), GTK_TOOLBAR(data->ui_data->find_toolbar));
    gtk_widget_show_all(GTK_WIDGET(data->window));
}	

/* initialize window day*/
static void init_day(AppData* data)
{
    GtkWidget* button_search;
    GtkWidget* field_search;
    GtkWidget* day_root_widget;

    day_root_widget = get_widget("day", data);

    button_search = get_widget("day_button_search", data);
    field_search = get_widget("day_field_search", data);

    g_signal_connect(G_OBJECT(button_search), "clicked",
		     G_CALLBACK(search), data);
}

/* init windows */
static void initialization_all_windows(AppData* data)
{
    init_calendar(data);
    init_day(data);
    init_event_edit(data);
    init_settings(data);
    init_import_events(data);
}

static void init_import_events(AppData* data)
{
    GtkWidget* widget;
    widget = get_widget("import_events", data);
}

static void init_settings(AppData* data)
{
    gboolean fullscreen;
    GtkWidget* widget;

    widget = get_widget("settings_check_fullscreen", data);
    
    fullscreen = g_key_file_get_boolean(data->KeyFile,
					"GUI",
					"AutoFullScreen",
					NULL);

    if (fullscreen) {
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), TRUE);
    } else {
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), FALSE);
    }
}

static void init_event_edit(AppData* data)
{
    GtkWidget* widget;

    widget = get_widget("event_edit_combobox_type", data);
    g_signal_connect(G_OBJECT(widget), "changed",
		     G_CALLBACK(ev_changed_type), data);

    widget = get_widget("event_edit_combobox_reminder", data);
    g_signal_connect(G_OBJECT(widget), "changed",
                     G_CALLBACK(event_edit_set_reminder), data);

    /* init hildon date editor */
    data->ui_data->start_date_editor =hildon_date_button_new(0, HILDON_BUTTON_ARRANGEMENT_HORIZONTAL);
    data->ui_data->end_date_editor = hildon_date_button_new(0, HILDON_BUTTON_ARRANGEMENT_HORIZONTAL);
    /* init hildon time editor */
    data->ui_data->start_time_editor = hildon_time_button_new(0, HILDON_BUTTON_ARRANGEMENT_HORIZONTAL);
    data->ui_data->end_time_editor = hildon_time_button_new(0, HILDON_BUTTON_ARRANGEMENT_HORIZONTAL);

    widget = get_widget("event_edit_box_date_start", data);
    gtk_box_pack_start(GTK_BOX(widget),
                       GTK_WIDGET(data->ui_data->start_date_editor),
                       TRUE,
                       TRUE,
                       0);

    widget = get_widget("event_edit_box_time_start", data);
    gtk_box_pack_start(GTK_BOX(widget),
                       GTK_WIDGET(data->ui_data->start_time_editor),
                       TRUE,
                       TRUE,
                       0);

    widget = get_widget("event_edit_box_date_end", data);
    gtk_box_pack_start(GTK_BOX(widget),
                       GTK_WIDGET(data->ui_data->end_date_editor),
                       TRUE,
                       TRUE,
                       0);

    widget = get_widget("event_edit_box_time_end", data);
    gtk_box_pack_start(GTK_BOX(widget),
                       GTK_WIDGET(data->ui_data->end_time_editor),
                       TRUE,
                       TRUE,
                       0);
}

/* clear of memory allocated */
void interface_main_view_destroy(AppUIData* main)
{
    g_free(main);
}


static void create_menu(AppData* data)
{
    GtkWidget* button;
    HildonAppMenu *main_menu = HILDON_APP_MENU(hildon_app_menu_new());

    /* Create menu entries */
    button = hildon_gtk_button_new(HILDON_SIZE_AUTO);
    gtk_button_set_label(GTK_BUTTON(button), _("Download events"));

    gtk_widget_set_name(GTK_WIDGET(button), "item_download_events");

    /* Attach callback to clicked signal */
    g_signal_connect_after(button, "clicked", G_CALLBACK(connection), data);

    /* Add entry to the view menu */
    hildon_app_menu_append(main_menu, GTK_BUTTON(button));

    /* add button "set account "*/    
    button = hildon_gtk_button_new(HILDON_SIZE_AUTO);
    gtk_button_set_label(GTK_BUTTON(button), _("Set account"));
    g_signal_connect_after(button, "clicked", G_CALLBACK(set_login), data);
    hildon_app_menu_append(main_menu, GTK_BUTTON(button));
		    
    /* add button "settings" */
    button = hildon_gtk_button_new(HILDON_SIZE_AUTO);
    gtk_button_set_label(GTK_BUTTON(button), _("Settings"));
    g_signal_connect_after(button, "clicked", G_CALLBACK(show_settings), data);
    /*hildon_app_menu_append(main_menu, GTK_BUTTON(button));*/

    /* add button "help" */
    button = hildon_gtk_button_new(HILDON_SIZE_AUTO);
    gtk_button_set_label(GTK_BUTTON(button), _("Help"));
    g_signal_connect_after(button, "clicked", G_CALLBACK(callback_help), data);
    hildon_app_menu_append(main_menu, GTK_BUTTON(button));
    
    /* "add button "exit" */
    button = hildon_gtk_button_new(HILDON_SIZE_AUTO);
    gtk_button_set_label(GTK_BUTTON(button), _("Exit"));
    g_signal_connect_after(button, "clicked", G_CALLBACK(question_exit), data);
    hildon_app_menu_append(main_menu, GTK_BUTTON(button));

    
    hildon_window_set_app_menu(HILDON_WINDOW(data->window),
		         GTK_MENU(main_menu));

    gtk_widget_show_all(GTK_WIDGET(main_menu));
}


/*
static void create_menu(AppData* data)
{
    GtkWidget* main_menu;
    GtkWidget* menu_synchronization;
    GtkWidget* menu_contacts;
    GtkWidget* menu_events;
    GtkWidget* menu_google;

    GtkWidget* item_synchronization;
    GtkWidget* item_contacts;
    GtkWidget* item_events;
    GtkWidget* item_settings;

    GtkWidget* item_exit;

    GtkWidget* item_contact_list;
    GtkWidget* item_contact_new;
    GtkWidget* item_contact_search;

    GtkWidget* item_event_search;

    GtkWidget* item_google;
    GtkWidget* item_download_events;
    GtkWidget* item_set_account;
*/
    /* Create new main menu */
//    main_menu = hildon_gtk_menu_new();
    /* Create new submenu for "Synchronization" */
//    menu_synchronization = hildon_gtk_menu_new();
    /* Create new submenu for "Contact list" */
//    menu_contacts = hildon_gtk_menu_new();
    /* Create new submenu for "Events" */
//    menu_events = hildon_gtk_menu_new();
    /* Create new submenu for "Google" */
/*    menu_google = hildon_gtk_menu_new();

    item_synchronization = gtk_menu_item_new_with_label(_("Synchronization"));
    item_contacts = gtk_menu_item_new_with_label(_("Contacts"));
    item_events = gtk_menu_item_new_with_label(_("Events"));
    item_settings = gtk_menu_item_new_with_label(_("Settings"));
    item_exit = gtk_menu_item_new_with_label(_("Exit"));

    item_contact_list = gtk_menu_item_new_with_label(_("Contact list"));
    item_contact_new = gtk_menu_item_new_with_label(_("New contact"));
    item_contact_search = gtk_menu_item_new_with_label(_("Search"));

    item_event_search = gtk_menu_item_new_with_label(_("Search"));

    item_google = gtk_menu_item_new_with_label(_("Google"));
    item_download_events = gtk_menu_item_new_with_label(_("Download events"));
    gtk_widget_set_name(GTK_WIDGET(item_download_events), "item_download_events");
    item_set_account = gtk_menu_item_new_with_label(_("Set account"));
*/
    /* Add menu items to right menus */
/*    gtk_menu_append(main_menu, item_synchronization);
    gtk_menu_append(menu_synchronization, item_google);
    gtk_menu_append(menu_google, item_download_events);
    gtk_menu_append(menu_google, item_set_account);

    gtk_menu_append(main_menu, item_contacts);
    gtk_menu_append(menu_contacts, item_contact_list);
    gtk_menu_append(menu_contacts, item_contact_new);
    gtk_menu_append(menu_contacts, item_contact_search);

    gtk_menu_append(main_menu, item_events);
    gtk_menu_append(menu_events, item_event_search);

    gtk_menu_append(main_menu, item_settings);
    gtk_menu_append(main_menu, item_exit);

    hildon_window_set_menu(HILDON_WINDOW(data->window),
			   GTK_MENU(main_menu));

    gtk_menu_item_set_submenu(GTK_MENU_ITEM(item_synchronization), menu_synchronization);
    gtk_menu_item_set_submenu(GTK_MENU_ITEM(item_contacts), menu_contacts);
    gtk_menu_item_set_submenu(GTK_MENU_ITEM(item_events), menu_events);
    gtk_menu_item_set_submenu(GTK_MENU_ITEM(item_google), menu_google);
*/
    /* Attach the callback functions to the activate signal */
/*    g_signal_connect(G_OBJECT(item_settings), "activate",
		     G_CALLBACK(show_settings), data);
    g_signal_connect(G_OBJECT(item_exit), "activate",
		     G_CALLBACK(question_exit), data);

    g_signal_connect(G_OBJECT(item_download_events), "activate",
		     G_CALLBACK(connection), data);

    g_signal_connect(G_OBJECT(item_set_account), "activate",
		     G_CALLBACK(set_login), data);
*/
    /* not realised feature yet*/
/*    g_signal_connect(G_OBJECT(item_contact_list), "activate",
                     G_CALLBACK(not_realised_feature), data);

    g_signal_connect(G_OBJECT(item_contact_new), "activate",
                     G_CALLBACK(not_realised_feature), data);

    g_signal_connect(G_OBJECT(item_contact_search), "activate",
                     G_CALLBACK(not_realised_feature), data);

    g_signal_connect(G_OBJECT(item_event_search), "activate",
                     G_CALLBACK(not_realised_feature), data);
*/
    /* Make all menu widgets visible */
/*    gtk_widget_show_all(GTK_WIDGET(main_menu));
}
*/
static void create_toolbar(AppData* data)
{
    /* Create toolbar */
    data->ui_data->toolbar = gtk_toolbar_new();

    /* Add toolbar HildonWindow */
    hildon_window_add_toolbar(data->window,
			      GTK_TOOLBAR(data->ui_data->toolbar));
}

static void tb_add_main_btns(AppData* data)
{
    GtkToolItem* tb_calendar;
    GtkToolItem* tb_ev_new;
    GtkToolItem* tb_separator;
    GtkWidget* icon_calendar;

    const gchar* widget_name;

    icon_calendar = gtk_image_new_from_file(CALENDAR_PIXMAP);

    /* Create separator */
    tb_separator = gtk_separator_tool_item_new();

    /* Create toolbar static button */
    tb_calendar = gtk_tool_button_new(icon_calendar, "Calendar");
    g_signal_connect(G_OBJECT(tb_calendar), "clicked",
		     GTK_SIGNAL_FUNC(show_calendar), data);

    data->ui_data->tb_today = gtk_tool_button_new(gtk_image_new_from_stock(GTK_STOCK_HOME, HILDON_ICON_PIXEL_SIZE_TOOLBAR), "Today");
    g_signal_connect(G_OBJECT(data->ui_data->tb_today), "clicked",
		     GTK_SIGNAL_FUNC(show_day), data);

    tb_ev_new = gtk_tool_button_new(gtk_image_new_from_stock(GTK_STOCK_NEW, HILDON_ICON_PIXEL_SIZE_TOOLBAR), "New");
    g_signal_connect(G_OBJECT(tb_ev_new), "clicked",
		     GTK_SIGNAL_FUNC(show_event_new), data);

    widget_name = gtk_widget_get_name(GTK_WIDGET(data->ui_data->current));

    if (strcmp(widget_name, "calendar")) {
	gtk_toolbar_insert(GTK_TOOLBAR(data->ui_data->toolbar),
			   tb_calendar, -1);
    }

    if (strcmp(widget_name, "day")) {
	gtk_toolbar_insert(GTK_TOOLBAR(data->ui_data->toolbar),
			   data->ui_data->tb_today, -1);
    }

    if (strcmp(widget_name, "event_edit") != 0 && strcmp(widget_name, "settings") != 0) {
	gtk_toolbar_insert(GTK_TOOLBAR(data->ui_data->toolbar),
			   tb_ev_new,
			   -1);
    }

    gtk_toolbar_insert(GTK_TOOLBAR(data->ui_data->toolbar),
		       tb_separator,
		       -1);
}

void show_window(const char* name_id, AppData* data)
{
    GtkWidget* widget;
    widget = get_widget(name_id, data);
    change_windows(widget, data);
}
