/*
 * Copyright (C) 2008-2009 Petrozavodsk State University
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */
#ifndef REMOTE_STORAGE_H
#define REMOTE_STORAGE_H

#include <events/events.h>
#include <remote_storage/protocols/google.h>

/**
 * Download events from service
 *
 * @param service    Service type
 * @param data       AppData data structure pointer
 * @param error      GError error structure pointer
 * @return Pointer on array of events
 *
*/

event *ev_rcv_event_download(RemoteStorage service, AppData*, GError** error);

#endif

