/*
 * Copyright (C) 2008-2009 Petrozavodsk State University
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */
#ifndef GOOGLE_H
#define GOOGLE_H

#include <stdio.h>
#include <string.h>
#include <string.h>
#include <appdata.h>
#include <remote_storage/protocols/curl_request.h>
#include <json.h>
#include <time.h>
#include <events/events.h>


#define SOURCE  "kimi-Kimi-0.1"
#define SERVICE "cl"

/*Some JSON string defines */
#define JSON_FEED "feed"
#define JSON_ENTRY "entry"
#define JSON_ID "id"
#define JSON_T "$t"
#define JSON_GOOGLE "Google:"
#define JSON_TITLE "title"
#define JSON_CONTENT "content"
#define JSON_GD_WHEN "gd$when"
#define JSON_GD_WHERE "gd$where"
#define JSON_GD_REMINDER "gd$reminder"
#define JSON_GD_RECURRENCE "gd$recurrence"
#define JSON_START_TIME "startTime"
#define JSON_END_TIME "endTime"
#define JSON_ICAL_RECURR_FORMAT "DTSTART;%*[^:]:%15[0-9T] DTEND;%*[^:]:%15[0-9T]"
#define JSON_GOOGLE_TIME_FORMAT "%FT%T"
#define JSON_GOOGLE_RECURR_TIME_FORMAT "%Y%m%dT%H%M%S"
#define JSON_VALUE_STRING "valueString"
#define JSON_MINUTES "minutes"

/*Data Strings for test framework*/
#ifdef TEST

#define GOOGLE_ANSW_STR_CORRECT "{\"version\":\"1.0\",\"encoding\":\"UTF-8\",\"feed\":{\"entry\":[{\"id\":{\"$t\":\"http://www.google.com/calendar/feeds/default/private/full/j06g1pv9m266uvkpor54lrondg\"},\"title\":{\"$t\":\"test_title\",\"type\":\"text\"},\"content\":{\"$t\":\"test_content\",\"type\":\"text\"},\"gd$where\":[{\"valueString\":\"test_where\"}],\"gd$when\":[{\"endTime\":\"2009-12-19T00:01:00.000+03:00\",\"startTime\":\"2009-12-19T00:00:00.000+03:00\"}]}]}}"

#define GOOGLE_ANSW_STR_INCORRECT "{\"version\":\"1.0\",\"encoding\":\"UTF-8\",\"food\":{\"entry\":[{\"id\":{\"$t\":\"http://www.google.com/calendar/feeds/default/private/full/j06g1pv9266uvkpor54lrondg\"},\"title\":{\"$t\":\"test_title\",\"type\":\"text\"},\"content\":{\"$t\":\"test_content\",\"type\":\"text\"},\"gd$where\":[{\"valueString\":\"test_where\"}],\"gd$when\":[{\"endTime\":\"2009-12-19T00:01:00.000+03:00\",\"startTime\":\"2009-12-19T00:00:00.000+03:00\"}]}]}}"

#endif


/* Some Array size defines */
#define ARRAY_MAX_SIZE 1024
#define TIME_ARRAY_SIZE 200
/* Some Server Answer Defines */
#define SERV_ANSWER_OK 200
#define SERV_ANSWER_CREATED 201
#define SERV_ANSWER_REDIRECT 302
#define SER_ANSWER_UNAUTH 401

/* Event Type */
#define MEMO 0
#define MEETING 1

/* POST message template */
#define POST_MESSAGE_TEMPLATE "<entry xmlns='http://www.w3.org/2005/Atom' xmlns:gd='http://schemas.google.com/g/2005'><category scheme='http://schemas.google.com/g/2005#kind' term='http://schemas.google.com/g/2005#event'></category><title type='text'>%s</title><content type='text'>%s</content><gd:transparency value='http://schemas.google.com/g/2005#event.opaque'></gd:transparency><gd:eventStatus value='http://schemas.google.com/g/2005#event.confirmed'></gd:eventStatus><gd:where valueString='%s'></gd:where><gd:when startTime='%s.000' endTime='%s.000'></gd:when></entry>"

/* Some URL's defines */
#define AUTH_HEADER "Authorization: GoogleLogin "
#define AUTH_URL "https://www.google.com/accounts/ClientLogin?Email=%s&Passwd=%s&source=%s&service=%s"
#define EVENTS_URL "http://www.google.com/calendar/feeds/default/private/full?alt=json"


/* Error messages defines */
#define REM_STRG_ERR g_quark_from_static_string("rem_str_error_quark")
#define ACCOUNT_ERROR_CODE 1
#define ACCOUNT_ERROR "No Account Information in configure file" 
#define AUTH_ERROR "Authorization Error"
#define AUTH_ERROR_CODE 2
#define UPLOAD_ERROR_CODE 3
#define UPLOAD_ERROR "Upload Event Error"
#define DOWNLOAD_ERROR_CODE 4
#define DOWNLOAD_ERROR "Download Events Error"

/**
 * Authentification with Google
 * @param resp_code Pointer on response code storage
 * @param data Pointer on Application Data structure
 * @return Authentification token
 * */

char* protocols_google_authentication(int* resp_code, AppData* data, GError** error);

/**
 * Json Format Parser
 * @param tmp Pointer on events string
 * @return Pointer on events
 * */

event* protocols_json_request_parser(char* tmp);

/**
 * Download events from google
 * @param data Pointer on application data structure
 * @param error Pointer on error handler
 * @return Pointer on events
 * */

event* protocols_google_events_download(AppData* data, GError** error);

/**
 * Upload event to google
 * @param data Pointer on application data structure
 * @param error Pointer on error handler
 * @return Pointer on string, what contain a event ID at Google
 * */

int protocols_google_event_upload(AppData* data, GError** error);

#endif
