/*
 * Copyright (C) 2008-2009 Petrozavodsk State University
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */
#ifndef CURL_REQUEST_H
#define CURL_REQUEST_H

#include <stdio.h>
#include <string.h>
#include <curl/curl.h>
#include <appdata.h>

struct MemoryStruct {
    char* memory;
    size_t size;
};

/**
 * Curl GET module
 * @param url URL for request
 * @param data pointer on Application Data Structure
 * @param http_header Header of request
 * @param https SSL flag(0 - Don't user SSL, 1 - Use SSL)
 * @param resp_code Response Code storage
 * @return Body of server answer
 * */

char* protocols_curl_get(const char* url, AppData* data,
			 struct curl_slist* headers,
			 int https, int* resp_code);

/**
 * Curl POST module
 * @param url URL for request
 * @param http_body Body of the posted message
 * @param data pointer on Application Data Structure
 * @param http_header Header of request
 * @param https SSL flag(0 - Don't user SSL, 1 - Use SSL)
 * @param resp_code Response Code storage
 * @return Body of server answer
 * */
char* protocols_curl_post(const char* url, char* send_data, AppData* data,
			  struct curl_slist* headers,
			  int https, int* resp_code);

/**
 * Curl header set module
 * @param header pointer to header
 * @return headers pointer to list of headers
 * */

struct curl_slist* protocols_curl_set_header(struct curl_slist* headers, const char* header);

static void* protocols_myrealloc(void* ptr, size_t size);
static size_t protocols_write_memory_callback(void* ptr, size_t size,
					      size_t nmemb, void* mydata);

#endif
