/*
 * Copyright (C) 2008-2009 Petrozavodsk State University
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */
#ifndef APPDATA_H
#define APPDATA_H

#include <libosso.h>
#include <glade/glade.h>
#include <gtk/gtk.h>
#include <hildon/hildon.h>
#include <glib.h>
#include <string.h>
#include <libintl.h>
#include <stdio.h>
#include <stdlib.h>
#include <libalarm.h>
#include <gdk/gdkkeysyms.h>

#include <libebook/e-book.h>
#include <libosso-abook/osso-abook.h>


#include <conic.h>
//#include <conicconnection.h>

#include <locale.h>
#define _(String) gettext(String)

#define SETTINGS_DIR ".kimi"
#include <sqlite3.h>

#define CONIC

typedef struct
{
    time_t start_time;
    time_t end_time;
    int* days;
    int n_days;
    int repeat;
    int type;
} period;

typedef struct {
    int id;
    int id_type;
    char* title;
    time_t start_time;
    time_t end_time;
    char* description;
    time_t remind;
    cookie_t alarm_cookie;
    //contacts* guests;
    period* per;
    char* location;
    char* service_event_id;

    GList* contact_list;
} event;

/** List of events IDs per each date */
struct date_id_list {
    time_t date;	/**<< Date                        */
    int *ids;		/**<< Array of events IDs         */
    size_t ids_size;	/**<< Size of an events IDs array */
};

typedef struct date_id_list date_id_list;

typedef enum
{
    GOOGLE_CALENDAR     = 0,
    VKONTAKTE_CALENDAR  = 1
} RemoteStorage;

typedef struct
{
    sqlite3_stmt* insert;
    sqlite3_stmt* insert_new;
    sqlite3_stmt* get_last_id;
    sqlite3_stmt* get_alarm;
    sqlite3_stmt* del;
    sqlite3_stmt* get_period;
    sqlite3_stmt* get_by_id;
    sqlite3_stmt* update_cookie;

    sqlite3_stmt* add_contact;
    sqlite3_stmt* get_contacts_by_id;
    sqlite3_stmt* remove_by_contact_id;
    sqlite3_stmt* remove_contact;
    sqlite3_stmt* remove_by_event_id;
} AppDBData;

typedef enum
{
    DB_INT,
    DB_INT64,
    DB_TEXT,
    DB_END,
    DB_SKIP
} DBType;

typedef enum {
    REPEAT_UNSET,
    REPEAT_EVERY_DAY,
    REPEAT_WORK_DAYS,
    REPEAT_MON_WED_FRI,
    REPEAT_TUE_THU,
    REPEAT_EVERY_WEEK,
    REPEAT_EVERY_2WEEK,
    REPEAT_EVERY_MONTH,
    REPEAT_EVERY_YEAR,
    REPEAT_OTHER
} RepeatType;

typedef struct _AppUIData AppUIData;
struct _AppUIData {
    gboolean fullscreen;
    GladeXML* xml;
    GtkWidget* current;
    GtkWidget* previous;
    GtkWidget* previous_settings;
    GtkWidget* cal;

    GtkWidget* ev_tree_view;
    GtkWidget* ev_import_tree_view;
    GtkWidget* ev_search_tree_view;

    GtkToolItem* tb_today;
    GtkToolItem* tb_ev_edit;
    /* Toolbar */
    GtkWidget* toolbar;
    GtkWidget* find_toolbar;
    
    GtkWidget* select_date_calendar;
    
    GtkWidget* start_time_editor;
    GtkWidget* end_time_editor;
    GtkWidget* start_date_editor;
    GtkWidget* end_date_editor;
};

typedef struct _AppData AppData;
struct _AppData {
    HildonProgram* program;	/* handle to application */
    HildonWindow* window;	/* handle to app's window */
    osso_context_t* osso;	/* handle to osso */
    AppUIData* ui_data;
    char* google_auth;
    GKeyFile* KeyFile;
    
    sqlite3* sqlite;
    AppDBData db_data;

    date_id_list* id_list;
    event** google_events;
    event* ev_upload;
   
    guint id_current_ev;

    ConIcConnection* connection;
    gboolean con_status_up_down; /* 0 - download; 1 - upload*/
    gulong handler;

    EBook* book;
    OssoABookAggregator* aggr;
    //EBookView* book_view;
    //OssoABookContactModel* contact_model;
    //GtkWidget* contact_view;
};

/**
 * @brief Get full filename in homedir
 *
 * 
 * @param filename Filename
 * @return Full path
 */
char *build_full_path(const char* filename);
//int is_dst(
#endif
