#include "mainwindow.h"
#include "ui_mainwindow.h"

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);
    connect(ui->rtlSlider, SIGNAL(sliderMoved(int)), this, SLOT(ledOn(int)));
    connect(ui->actionAbout, SIGNAL(triggered()), this, SLOT(showAbout()));
    QMainWindow::setCentralWidget(ui->verticalLayoutWidget);
#ifdef Q_WS_MAEMO_5
    disableEngine();
    watchSliderState();
#endif
}

MainWindow::~MainWindow()
{
    delete ui;
#ifdef Q_WS_MAEMO_5
    qDebug() << "Enabling engine3...";
    system("echo run > /sys/class/i2c-adapter/i2c-2/2-0032/engine3_mode");
#endif
}

void MainWindow::disableEngine()
{
    qDebug() << "Disabling engine3...";
    system("echo disabled > /sys/class/i2c-adapter/i2c-2/2-0032/engine3_mode");
    system("for leds in 1 2 3 4 5 6; do echo 0 > /sys/class/leds/lp5523:kb$leds/brightness; done");
}

void MainWindow::ledOn(int number)
{
    qDebug() << number;
#ifdef Q_WS_MAEMO_5
    system(QString("kbledon.sh on %2").arg(number).toUtf8().constData());
    system(QString("kbledon.sh off %2 &").arg(number).toUtf8().constData());
#endif
}

void MainWindow::ledOff(int number)
{
    system(QString("/root/kbledon.sh off %2").arg(number).toUtf8().constData());
}


void MainWindow::watchSliderState()
{
    QDBusConnection::systemBus().connect("org.freedesktop.Hal",
                                         "/org/freedesktop/Hal/devices/platform_slide",
                                         "org.freedesktop.Hal.Device",
                                         "PropertyModified",
                                         this, SLOT(onSlideChanged()));
}

void MainWindow::onSlideChanged()
{
    bool isClosed = QDBusInterface("org.freedesktop.Hal", "/org/freedesktop/Hal/devices/platform_slide", "org.freedesktop.Hal.Device", QDBusConnection::systemBus()).call("GetProperty", "button.state.value").arguments().first().toBool();
    if(isClosed) {
        qDebug() << "Keyboard closed, engine3 reenabled.";
    }
    if (!isClosed){
        qDebug() << "Keyboard opened, disabling engine3";
        disableEngine();
    }
}

void MainWindow::showAbout()
{
    QMessageBox::about(this, "About Keyboards LEDs", "A simple application to control the keyboard LEDs.\n\n(C) 2010 Mohammad Abu-Garbeyyeh\nLicensed under GPLv3");
}
