/*
 * isp1704.h - ISP 1704 Register
 *
 * Copyright (C) 2008 Nokia Corporation
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 * NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef __ISP1704_H__
#define __ISP1704_H__

#define ISP1704_VENDOR_ID_LOW		0x00
#define ISP1704_VENDOR_ID_HIGH		0x01
#define ISP1704_PRODUCT_ID_LOW		0x02
#define ISP1704_PRODUCT_ID_HIGH		0x03
#define ISP1704_FUNC_CTRL		0x04
#define ISP1704_OTG_CTRL		0x0a
#define ISP1704_USB_INTRISE		0x0d
#define ISP1704_USB_INTFALL		0x10
#define ISP1704_DEBUG			0x15
#define ISP1704_SCRATCH			0x16
#define ISP1704_PWR_CTRL		0x3d

/* Function control */
#define ISP1704_FUNC_CTRL_FULL_SPEED	(1 << 0)
#define ISP1704_FUNC_CTRL_XCVRSELECT	0x3
#define ISP1704_FUNC_CTRL_XCVRSELECT_SHIFT	(1 << 0)
#define ISP1704_FUNC_CTRL_TERMSELECT	(1 << 2)
#define ISP1704_FUNC_CTRL_OPMODE	(1 << 3)
#define ISP1704_FUNC_CTRL_OPMODE_SHIFT	3
#define ISP1704_FUNC_CTRL_RESET		(1 << 5)
#define ISP1704_FUNC_CTRL_SUSPENDM	(1 << 6)

/* OTG Control */
#define ISP1704_OTG_CTRL_IDPULLUP	(1 << 0)
#define ISP1704_OTG_CTRL_DP_PULLDOWN	(1 << 1)
#define ISP1704_OTG_CTRL_DM_PULLDOWN	(1 << 2)
#define ISP1704_OTG_CTRL_DISCHRG_VBUS	(1 << 3)
#define ISP1704_OTG_CTRL_CHRG_VBUS	(1 << 4)
#define ISP1704_OTG_CTRL_DRV_VBUS_EXT	(1 << 6)
#define ISP1704_OTG_CTRL_USB_EXT_VBUS	(1 << 7)

/* Debug */
#define ISP1704_DEBUG_LINESTATE0	(1 << 0)
#define ISP1704_DEBUG_LINESTATE1	(1 << 1)

/* Power control */
#define ISP1704_PWR_CTRL_SWCTRL		(1 << 0)
#define ISP1704_PWR_CTRL_DET_COMP	(1 << 1)
#define ISP1704_PWR_CTRL_BVALID_RISE	(1 << 2)
#define ISP1704_PWR_CTRL_BVALID_FALL	(1 << 3)
#define ISP1704_PWR_CTRL_DP_WKPU_EN	(1 << 4)
#define ISP1704_PWR_CTRL_VDAT_DET	(1 << 5)
#define ISP1704_PWR_CTRL_DPVSRC_EN	(1 << 6)
#define ISP1704_PWR_CTRL_HWDETECT	(1 << 7)

#endif	/* __ISP1704_H__ */
