/*

Kana of The Day -- Japanese kana learning application for Maemo Fremantle.
Copyright (C) 2012 M. Hossein Azadmanesh (mhazadmanesh2009@gmail.com)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

*/

#include "kanadb.h"

#include <QDateTime>
#include <QFileInfo>
#include <QDir>
#include <QFile>
#include <QTextStream>

QString GetConfigFilePath()
{
    return QDir::homePath() + "/.kanaotd";
}

bool ReadPermFromFile(int& kana, int& kana_set, int*& permtab, bool& fileerror)
{
    QString configFilePath = GetConfigFilePath();

    if (!QFileInfo(configFilePath).exists())
    {
        kana = 0;
        kana_set = 0;
        seed_random();
        generate_kanaset(0, permtab);
        generate_permutation(0, permtab);
        return false;
    }

    QFile configFile(configFilePath);
    if (configFile.open(QFile::ReadOnly))
    {
        QTextStream in(&configFile);
        if (in.readLine() != "KanaOfTheDay1")
        {
            fileerror = true;

            kana = 0;
            kana_set = 0;
            generate_kanaset(0, permtab);

            configFile.close();

            return true;
        }

        kana_set = in.readLine().toInt();
        if (kana_set < 0 || kana_set >= KANA_SET_COUNT)
        {
            fileerror = true;
            kana_set = 0;
        }

        QStringList perms = in.readLine().split(' ');
        int kana_set_len = get_kana_set_len(kana_set);
        if (perms.length() == kana_set_len)
        {
            permtab = new int[kana_set_len];
            for (int i = 0; i < kana_set_len; i++)
                permtab[i] = perms[i].toInt();
        }
        else
        {
            fileerror = true;
            generate_kanaset(kana_set, permtab);
        }

        kana = in.readLine().toInt();
        if (kana < 0 || kana >= kana_set_len)
        {
            fileerror = true;
            kana = 0;
        }

        configFile.close();
    }

    return true;
}

void WritePermToFile(int kana, int kana_set, int* permtab)
{
    QFile configFile(GetConfigFilePath());
    if (configFile.open(QFile::WriteOnly))
    {
        QTextStream out(&configFile);
        out << "KanaOfTheDay1\n";
        out << QString::number(kana_set) << "\n";
        QString permstr = "";
        int count = get_kana_set_len(kana_set);
        for (int i = 0; i < count; i++)
            permstr += QString::number(permtab[i]) + " ";
        out << permstr.left(permstr.length() - 1) << "\n";
        out << kana << "\n";
        configFile.close();
    }
}

int TodayKanaIndex(int kana, int kana_set, int* permtab)
{
    int daysTo = QDateTime(QDate(1970, 1, 1), QTime(12, 0, 0)).daysTo(QDateTime::currentDateTime());
    int displayedKanaIndex = abs(daysTo + kana) % get_kana_set_len(kana_set);
    return permtab[displayedKanaIndex];
}
