/*

Kana of The Day -- Japanese kana learning application for Maemo Fremantle.
Copyright (C) 2012 M. Hossein Azadmanesh (mhazadmanesh2009@gmail.com)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

*/

#pragma once
#include <QWidget>

class QBoxLayout;
class QImageReader;
class QLabel;
class QTimer;

//class QFile;

class KanaOTDHomeWidget : public QWidget
{
    Q_OBJECT

private:
    QLabel* lbl_roma;
    QLabel* lbl_hira;
    QLabel* lbl_kata;

    int current_kana;
    int current_kana_set;
    int* current_permtab;

    bool mousePressed;
    bool horizontal;
    QBoxLayout* m_layout;

    bool loadingAnim;
    int loadingAnimFrame;
    QImageReader* imgLoading;
    QTimer* loadingAnimTimer;

    //QFile* f;

public:
    /// QFileInfo(qApp->applicationFilePath()).fileName() didn't work, so we had to use
    ///     argv0 to find the app name.
    explicit KanaOTDHomeWidget(bool is_horizontal, QWidget *parent = 0);
    ~KanaOTDHomeWidget();
    virtual QSize sizeHint() const;
    
protected:
    void moveEvent(QMoveEvent*);
    void paintEvent(QPaintEvent* event);
    void mousePressEvent(QMouseEvent* event);
    //void mouseMoveEvent(QMouseEvent* event);
    void mouseReleaseEvent(QMouseEvent* event);

signals:
    
public slots:
    void ReadKanaFromFile();
    void UpdateKana(int index);
    void stopLoadingAnimation();
};
