/*

Kana of The Day -- Japanese kana learning application for Maemo Fremantle.
Copyright (C) 2012 M. Hossein Azadmanesh (mhazadmanesh2009@gmail.com)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

*/

/*
 * IMPORTANT: Most parts of this file are taken from different source files of the `kanatest` project
 *            and therefor are published by the same license.
 *
 *            There have been modifications.
 *
 *            The license for `kanatest` files follows:
 *
 */

/*
 * Kanatest
 *
 * Copyright (C) 2001-2004, 2006 Tomasz Maka <pasp@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include "kanadb.h"

//For rand, srand:
#include <stdlib.h>
//For time:
#include <time.h>

#define N_

const char* get_kana_sign(int index, int kana_type /*, gboolean translated*/) {

/* romanji | hiragana | katakana */

const char *kana_signs[] = {

    /* TRANSLATORS: if there exist several possible transliterations for kanas, they must be separated by comma */

    /* 0 */                 /* 1 */                     /* 2 */                     /* 3 */                 /* 4 */
    N_("a"),  "あ", "ア",   N_("i"),   "い", "イ",      N_("u"),   "う", "ウ",      N_("e"),  "え", "エ",   N_("o"),  "お", "オ",
    /* 5 */                 /* 6 */                     /* 7 */                     /* 8 */                 /* 9 */
    N_("ka"), "か", "カ",   N_("ki"),  "き", "キ",      N_("ku"),  "く", "ク",      N_("ke"), "け", "ケ",   N_("ko"), "こ", "コ",
    /* 10 */                /* 11 */                    /* 12 */                    /* 13 */                /* 14 */
    N_("sa"), "さ", "サ",   N_("shi"), "し", "シ",      N_("su"),  "す", "ス",      N_("se"), "せ", "セ",   N_("so"), "そ", "ソ",
    /* 15 */                /* 16 */                    /* 17 */                    /* 18 */                /* 19 */
    N_("ta"), "た", "タ",   N_("chi"), "ち", "チ",      N_("tsu"), "つ", "ツ",      N_("te"), "て", "テ",   N_("to"), "と", "ト",

    /* 20 */                /* 21 */                    /* 22 */                    /* 23 */                /* 24 */
    N_("na"), "な", "ナ",   N_("ni"), "に", "ニ",       N_("nu"), "ぬ", "ヌ",       N_("ne"), "ね", "ネ",   N_("no"), "の", "ノ",
    /* 25 */                /* 26 */                    /* 27 */                    /* 28 */                /* 29 */
    N_("ha"), "は", "ハ",   N_("hi"), "ひ", "ヒ",       N_("fu"), "ふ", "フ",       N_("he"), "へ", "ヘ",   N_("ho"), "ほ", "ホ",
    /* 30 */                /* 31 */                    /* 32 */                    /* 33 */                /* 34 */
    N_("ma"), "ま", "マ",   N_("mi"), "み", "ミ",       N_("mu"), "む", " ",       N_("me"), "め", "メ",   N_("mo"), "も", "モ",
    /* 35 */                                            /* 36 */                                            /* 37 */
    N_("ya"), "や", "ヤ",                               N_("yu"), "ゆ", "ユ",                               N_("yo"), "よ", "ヨ",
    /* 38 */                /* 39 */                    /* 40 */                    /* 41 */                /* 42 */
    N_("ra"), "ら", "ラ",   N_("ri"), "り", "リ",       N_("ru"), "る", "ル",       N_("re"), "れ", "レ",   N_("ro"), "ろ", "ロ",

    /* 43 */                                                                                                /* 44 */
    N_("wa"), "わ", "ワ",                                                                                   N_("wo"), "を", "ヲ",
    /* 45 */
    N_("n"),  "ん", "ン",

    /* 46 */                /* 47 */                    /* 48 */                    /* 49 */                /* 50 */
    N_("ga"), "が", "ガ",   N_("gi"), "ぎ", "ギ",       N_("gu"), "ぐ", "グ",       N_("ge"), "げ", "ゲ",   N_("go"), "ご", "ゴ",
    /* 51 */                /* 52 */                    /* 53 */                    /* 54 */                /* 55 */
    N_("za"), "ざ", "ザ",   N_("ji"), "じ", "ジ",       N_("zu"), "ず", "ズ",       N_("ze"), "ぜ", "ゼ",   N_("zo"), "ぞ", "ゾ",
    /* 56 */                /* 57 */                    /* 58 */                    /* 59 */                /* 60 */
    N_("da"), " ", "ダ",   N_("di,ji"), "ぢ", "ヂ",    N_("du,zu"), "づ", "ヅ",    N_("de"), "で", "デ",   N_("do"), "ど", "ド",
    /* 61 */                /* 62 */                    /* 63 */                    /* 64 */                /* 65 */
    N_("ba"), "ば", "バ",   N_("bi"), "び", "ビ",       N_("bu"), "ぶ", "ブ",       N_("be"), "べ", "ベ",   N_("bo"), "ぼ", "ボ",
    /* 66 */                /* 67 */                    /* 68 */                    /* 69 */                /* 70 */
    N_("pa"), "ぱ", "パ",   N_("pi"), "ぴ", "ピ",       N_("pu"), "ぷ", "プ",       N_("pe"), "ぺ", "ペ",   N_("po"), "ぽ", "ポ",

    /* 71 */                                            /* 72 */                                            /* 73 */
    N_("kya"), "きゃ", "キャ",                          N_("kyu"), "きゅ", "キュ",                          N_("kyo"), "きょ", "キョ",
    /* 74 */                                            /* 75 */                                            /* 76 */
    N_("sha"), "しゃ", "シャ",                          N_("shu"), "しゅ", "シュ",                          N_("sho"), "しょ", "ショ",
    /* 77 */                                            /* 78 */                                            /* 79 */
    N_("cha"), "ちゃ", "チャ",                          N_("chu"), "ちゅ", "チュ",                          N_("cho"), "ちょ", "チョ",
    /* 80 */                                            /* 81 */                                            /* 82 */
    N_("nya"), "にゃ", "ニャ",                          N_("nyu"), "にゅ", "ニュ",                          N_("nyo"), "にょ", "ニョ",
    /* 83 */                                            /* 84 */                                            /* 85 */
    N_("hya"), "ひゃ", "ヒャ",                          N_("hyu"), "ひゅ", "ヒュ",                          N_("hyo"), "ひょ", "ヒョ",
    /* 86 */                                            /* 87 */                                            /* 88 */
    N_("mya"), "みゃ", "ミャ",                          N_("myu"), "みゅ", "ミュ",                          N_("myo"), "みょ", "ミョ",
    /* 89 */                                            /* 90 */                                            /* 91 */
    N_("rya"), "りゃ", "リャ",                          N_("ryu"), "りゅ", "リュ",                          N_("ryo"), "りょ", "リョ",

    /* 92 */                                            /* 93 */                                            /* 94 */
    N_("gya"), "ぎゃ", "ギャ",                          N_("gyu"),  "ぎゅ", "ギュ",                         N_("gyo"), "ぎょ", "ギョ",
    /* 95 */                                            /* 96 */                                            /* 97 */
    N_("ja"),  "じゃ", "ジャ",                          N_("ju"),   "じゅ", "ジュ",                         N_("jo"),  "じょ", "ジョ",
    /* 98 */                                            /* 99 */                                            /* 100 */
    N_("bya"), "びゃ", "ビャ",                          N_("byu"),  "びゅ", "ビュ",                         N_("byo"), "びょ", "ビョ",
    /* 101 */                                           /* 102 */                                           /* 103 */
    N_("pya"), "ぴゃ", "ピャ",                          N_("pyu"),  "ぴゅ", "ピュ",                         N_("pyo"), "ぴょ", "ピョ"

};

    //if (translated == TRUE) {
    //    return gettext(kana_signs[3 * index + kana_type]);
    //} else {
        return kana_signs[3 * index + kana_type];
    //}
}

#define     KANA_SET_0_LEN              104
#define     KANA_SET_1_LEN              46
#define     KANA_SET_2_LEN              5
#define     KANA_SET_3_LEN              5
#define     KANA_SET_4_LEN              5
#define     KANA_SET_5_LEN              5
#define     KANA_SET_6_LEN              5
#define     KANA_SET_7_LEN              5
#define     KANA_SET_8_LEN              5
#define     KANA_SET_9_LEN              3
#define     KANA_SET_10_LEN             5
#define     KANA_SET_11_LEN             3
#define     KANA_SET_12_LEN             25
#define     KANA_SET_13_LEN             33

int get_kana_set_len(int set)
{
    //ADDED
    const int kana_set_lens[] = {
       104, 46, 5, 5, 5, 5, 5, 5, 5, 3, 5, 3, 25, 33
    };

    return kana_set_lens[set];
}

const char* get_kana_set_name (int set) {

const char *kana_set_name[] = {
    N_("All kanas"),
    N_("All basic letters"),
    N_("A-I-U-E-O"),
    N_("KA-KI-KU-KE-KO"),
    N_("SA-SHI-SU-SE-SO"),
    N_("TA-CHI-TSU-TE-TO"),
    N_("NA-NI-NU-NE-NO"),
    N_("HA-HI-FU-HE-HO"),
    N_("MA-MI-MU-ME-MO"),
    N_("YA-YU-YO"),
    N_("RA-RI-RU-RE-RO"),
    N_("WA-WO-N"),
    N_("Combo letters - part 1"),
    N_("Combo letters - part 2"),
    //N_("User-defined lesson") //ADDED: This last one is never used.
};

    //return gettext(kana_set_name[set]);
    return kana_set_name[set];
}

void seed_random()
{
    srand(time(NULL));
}

void generate_permutation (int set, int*& permtab) {

    const int kana_signs_set_1_idx[] = {
        0, 1, 2, 3, 4,                  /* A-I-U-E-O */
        5, 6, 7, 8, 9,                  /* KA-KI-KU-KE-KO */
        10, 11, 12, 13, 14,             /* SA-SHI-SU-SE-SO */
        15, 16, 17, 18, 19,             /* TA-CHI-TSU-TE-TO */
        20, 21, 22, 23, 24,             /* NA-NI-NU-NE-NO */
        25, 26, 27, 28, 29,             /* HA-HI-FU-HE-HO */
        30, 31, 32, 33, 34,             /* MA-MI-MU-ME-MO */
        35, 36, 37,                     /* YA-YU-YO */
        38, 39, 40, 41, 42,             /* RA-RI-RU-RE-RO */
        43, 44, 45                      /* WA-WO-N */
    };

    const int kana_signs_set_2_idx[] = {     /* A-I-U-E-O */
        0, 1, 2, 3, 4
    };

    const int kana_signs_set_3_idx[] = {     /* KA-KI-KU-KE-KO */
        5, 6, 7, 8, 9
    };

    const int kana_signs_set_4_idx[] = {     /* SA-SHI-SU-SE-SO */
        10, 11, 12, 13, 14
    };

    const int kana_signs_set_5_idx[] = {     /* TA-CHI-TSU-TE-TO */
        15, 16, 17, 18, 19
    };

    const int kana_signs_set_6_idx[] = {     /* NA-NI-NU-NE-NO */
        20, 21, 22, 23, 24
    };

    const int kana_signs_set_7_idx[] = {     /* HA-HI-FU-HE-HO */
        25, 26, 27, 28, 29
    };

    const int kana_signs_set_8_idx[] = {     /* MA-MI-MU-ME-MO */
        30, 31, 32, 33, 34
    };

    const int kana_signs_set_9_idx[] = {     /* YA-YU-YO */
        35, 36, 37
    };

    const int kana_signs_set_10_idx[] = {    /* RA-RI-RU-RE-RO */
        38, 39, 40, 41, 42
    };

    const int kana_signs_set_11_idx[] = {    /* WA-WO-N */
        43, 44, 45
    };

    const int kana_signs_set_12_idx[] = {    /* Combo letters (part 1) */
        46, 47, 48, 49, 50, 51, 52, 53, 54, 55,
        56, 57, 58, 59, 60, 61, 62, 63, 64, 65,
        66, 67, 68, 69, 70
    };

    const int kana_signs_set_13_idx[] = {    /* Combo letters (part 2) */
        71, 72, 73, 74, 75, 76, 77, 78, 79, 80,
        81, 82, 83, 84, 85, 86, 87, 88, 89, 90,
        91, 92, 93, 94, 95, 96, 97, 98, 99, 100,
        101, 102, 103
    };

    const int* kana_signs_set_tabs[] = {
        0,                   /* kana_signs_set_0_idx */
        kana_signs_set_1_idx,
        kana_signs_set_2_idx,
        kana_signs_set_3_idx,
        kana_signs_set_4_idx,
        kana_signs_set_5_idx,
        kana_signs_set_6_idx,
        kana_signs_set_7_idx,
        kana_signs_set_8_idx,
        kana_signs_set_9_idx,
        kana_signs_set_10_idx,
        kana_signs_set_11_idx,
        kana_signs_set_12_idx,
        kana_signs_set_13_idx,
        //ADDED: User-defined set removed:
        //NULL                    /* kana_signs_set_14_idx */
    };

    //ADDED
    /* Copy data into permtab */
    int count = get_kana_set_len(set);
    permtab = new int[count];

    if (set == 0)
    {
        for (int i = 0; i < count; i++)
            permtab[i] = i;
    }
    else
    {
        for (int i = 0; i < count; i++)
            permtab[i] = kana_signs_set_tabs[set][i];
    }

    /* do a decent random permutation */
    int i, tmp, pos;
    for(i = count-1; i > 0; --i)
    {
        pos = rand() % (i+1);

        tmp = permtab[i];
        permtab[i] = permtab[pos];
        permtab[pos] = tmp;
    }
}
