// FROM: http://www.qtcentre.org/wiki/index.php?title=Rich_text_pushbutton_implementation
#include "widgetpushbutton.h"
 
#include <QPainter>
#include <QPixmap>
#include <QTextDocument>
#include <QIcon>
#include <QSize>
#include <QMenu>
#include <QStylePainter>
 
WidgetPushButton::WidgetPushButton(QWidget *parent) :
    QPushButton(parent)
{
}
 
void WidgetPushButton::setWidget(QWidget* w)
{
	this->w = w;
}
 
void WidgetPushButton::paintEvent(QPaintEvent *event)
{
    if (w != NULL) {
        QStylePainter p(this);
 
        QRect buttonRect = rect();
        QPoint point;
 
        QPixmap pixmap(w->size().width(), w->size().height());
        pixmap.fill(Qt::transparent);
        QPainter painter(&pixmap);
		w->render(&painter);
 
        if (!icon().isNull())
            point = QPoint(buttonRect.x() + buttonRect.width() / 2 + iconSize().width() / 2 + 2, buttonRect.y() + buttonRect.height() / 2);
        else
            point = QPoint(buttonRect.x() + buttonRect.width() / 2 - 1, buttonRect.y() + buttonRect.height() / 2);
 
        buttonRect.translate(point.x() - w->width() / 2, point.y() - w->height() / 2);
 
        p.drawControl(QStyle::CE_PushButton, getStyleOption());
        p.drawPixmap(buttonRect.left(), buttonRect.top(), w->width(), w->height(), pixmap);
    } else
        QPushButton::paintEvent(event);
}
 
QStyleOptionButton WidgetPushButton::getStyleOption() const
{
    QStyleOptionButton opt;
    opt.initFrom(this);
    opt.features = QStyleOptionButton::None;
    if (isFlat())
        opt.features |= QStyleOptionButton::Flat;
    if (menu())
        opt.features |= QStyleOptionButton::HasMenu;
    if (autoDefault() || isDefault())
        opt.features |= QStyleOptionButton::AutoDefaultButton;
    if (isDefault())
        opt.features |= QStyleOptionButton::DefaultButton;
    if (isDown() || (menu() && menu()->isVisible()))
        opt.state |= QStyle::State_Sunken;
    if (isChecked())
        opt.state |= QStyle::State_On;
    if (!isFlat() && !isDown())
        opt.state |= QStyle::State_Raised;
    opt.text = text();
    opt.icon = icon();
    opt.iconSize = iconSize();
    return opt;
}
