/*
 * This file is part of jSpeed.
 *
 * jSpeed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * jSpeed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with jSpeed.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef RECTANGLE_H
#define RECTANGLE_H

#include "graphicselement.h"
#include "location.h"

class QString;
class QGraphicsRectItem;
class QGraphicsItem;
class Reader;
class GraphicsScene;

class Rectangle : public GraphicsElement
{
public:
    enum Attribute {XPOS, YPOS, ZPOS, VISIBLEWHEN, WIDTH, HEIGHT, COLOR, ATTRIBUTE_COUNT};
    Rectangle(Reader* reader);
    virtual bool setAttribute(QString const& name, QString const& value);
    virtual void addToScene(GraphicsScene* scene);
    virtual void update();
    virtual QGraphicsItem* getElement() const;

private:
    QGraphicsRectItem* element_;
    int x_;
    int y_;
    int width_;
    int height_;
};

#endif
