/*
 * This file is part of jSpeed.
 *
 * jSpeed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * jSpeed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with jSpeed.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <QtCore/QUrl>
#include <QtCore/QDir>
#include <QMediaPlayer>
#include <QMediaContent>
#include "mediaplayer.h"
#include "settings.h"

namespace
{
    QString const FORMATS[MediaPlayer::FORMAT_COUNT] = {"mp3", "aac", "wav"};
    QString const LOCAL_SOUND_DIR = ":/resources/sounds/";
}

void MediaPlayer::init()
{
    getPlayer();
}

bool MediaPlayer::play(QString const& file)
{
    QMediaPlayer* player = getPlayer();

    QMediaContent media(QUrl::fromLocalFile(file));

    if(media.isNull())
    {
        return false;
    }

    player->setMedia(media);
    player->play();
    return true;
}

QMediaPlayer* MediaPlayer::getPlayer()
{
    static QMediaPlayer player;
    return &player;
}

void MediaPlayer::getSupportedFormats(QList<QString>& formats)
{
    formats.clear();

    for(int i = 0; i < FORMAT_COUNT; i++)
    {
        formats.push_back(FORMATS[i]);
    }
}

QString MediaPlayer::getFormatPattern()
{
   QString result = "";

   for(int i = 0; i < FORMAT_COUNT; i++)
   {
       result += "*." + FORMATS[i] + " ";
   }

   return result.trimmed();
}

QStringList MediaPlayer::getFormatPatterns()
{
    QStringList result;

    for(int i = 0; i < FORMAT_COUNT; i++)
    {
        result.push_back("*." + FORMATS[i]);
    }

    return result;
}

QString MediaPlayer::getSoundDir()
{
    return Settings::getDir() + "sounds" + QDir::separator();
}

QString const& MediaPlayer::getLocalSoundDir()
{
    return LOCAL_SOUND_DIR;
}

