/*
 * This file is part of jSpeed.
 *
 * jSpeed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * jSpeed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with jSpeed.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef MAINMENU_H
#define MAINMENU_H

#include <QtGui/QDialog>

class QVBoxLayout;
class QHBoxLayout;
class ThemeSelector;
class UnitSelector;
class PoiSettings;
class SpeedAlarmSettings;

class MainMenu : public QDialog
{
    Q_OBJECT

public:
    MainMenu(QWidget* parent = 0);
    void addAction(const QString& text, const QObject* receiver, const char* member);

signals:
    void resetTrip();
    void resetAll();
    void flip();
    void themeChanged();
    void unitChanged();
    void orientationChanged();

private slots:
    void selectTheme();
    void selectUnit();
    void showAbout();
    void confirmReset();
    void openPoiAlerts();
    void openSpeedAlarm();

private:
    QVBoxLayout* layout_;
    int itemCount_;
    QHBoxLayout* currentRow_;
    ThemeSelector* themeSelector_;
    UnitSelector* unitSelector_;
    PoiSettings* poiSettings_;
    SpeedAlarmSettings* speedAlarmSettings_;
    QDialog* aboutDialog_;
};

#endif
