/*
 * This file is part of jSpeed.
 *
 * jSpeed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * jSpeed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with jSpeed.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef COMPASS_H
#define COMPASS_H

#include <QtCore/QObject>
#include "graphicselement.h"

class QGraphicsPixmapItem;
class QTimeLine;
class QGraphicsItem;
class GraphicsScene;
class Reader;

class Compass : public GraphicsElement
{
    Q_OBJECT

public:
    enum Attribute {XPOS, YPOS, ZPOS, VISIBLEWHEN, SRC, XROTATIONPOINT, YROTATIONPOINT, ATTRIBUTE_COUNT};
    Compass(Reader* reader, bool animate);
    ~Compass();
    virtual bool setAttribute(QString const& name, QString const& value);
    virtual void addToScene(GraphicsScene* scene);
    virtual void update();
    virtual QGraphicsItem* getElement() const;

private slots:
    void setFrame(int frame);

private:
    bool loadImage(QString const& name);
    QGraphicsPixmapItem* element_;
    int xRotationPoint_;
    int yRotationPoint_;
    int x_;
    int y_;
    int targetAngle_;
    int startAngle_;
    int angle_;
    int width_;
    int height_;
    bool imageSet_;
    bool animate_;
    QTimeLine* timer_;
};

#endif
