/*
 * This file is part of jSpeed.
 *
 * jSpeed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * jSpeed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with jSpeed.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include "poireader.h"
#include "poiascreader.h"

namespace
{
    QString const READER_FILETYPES[PoiReader::READER_COUNT] = {"asc"};
}

PoiReader::PoiReader()
{
}

PoiReader* PoiReader::getReader(QString const& filename)
{
    QString lower = filename.toLower();
    QString type;
    Reader reader = READER_COUNT;

    for(int i = 0; i < READER_COUNT; i++)
    {
        if(lower.right(READER_FILETYPES[i].size()) == READER_FILETYPES[i])
        {
            reader = static_cast<Reader>(i);
            break;
        }
    }

    switch(reader)
    {
    case ASCREADER:
        return new PoiAscReader(filename);
        break;
    default:
        return 0;
    }
}

void PoiReader::setError(QString const& error)
{
    error_ = error;
}

QString const& PoiReader::error()
{
    return error_;
}

QString PoiReader::getFormatPattern()
{
    QString data = "";

    for(int i = 0; i < READER_COUNT; i++)
    {
        data += "*." + READER_FILETYPES[i] + " ";
    }

    return data.trimmed();
}

void PoiReader::getSupportedFormats(QList<QString>& formats)
{
    formats.clear();

    for(int i = 0; i < READER_COUNT; i++)
    {
        formats.push_back(READER_FILETYPES[i]);
    }
}
