/*
 * This file is part of jSpeed.
 *
 * jSpeed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * jSpeed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with jSpeed.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef FLICKEREFFECT_H
#define FLICKEREFFECT_H

#include <QtCore/QObject>
#include "effect.h"

class QString;
class QTimer;
class GraphicsElement;

class FlickerEffect : public QObject, public Effect
{
    Q_OBJECT

public:
    enum Attribute {INTERVAL, ATTRIBUTE_COUNT};
    FlickerEffect();
    ~FlickerEffect();
    virtual bool setAttribute(QString const& name, QString const& value);
    virtual void apply(GraphicsElement* item);

private slots:
    void updateVisibility();

private:
    int interval_;
    QTimer* timer_;
    GraphicsElement* item_;
};

#endif
