/*
 * This file is part of jSpeed.
 *
 * jSpeed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * jSpeed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with jSpeed.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef THEMESCHEDULER_H
#define THEMESCHEDULER_H

#include <QtCore/QObject>
#include <QtCore/QList>
#include <QtCore/QTime>
#include <QtCore/QTimer>

class QString;

class ThemeScheduler : public QObject
{
    Q_OBJECT

public:

    struct SchedulerItem
    {
        QTime time;
        QString theme;
    };

    ~ThemeScheduler();
    static ThemeScheduler& instance();
    static QString const& getDefaultTheme();
    void addItem(QTime const& time, QString const& theme);
    void removeItem(QTime const& time);
    void setEnabled(bool enabled);
    bool isEnabled() const;
    QString currentTheme() const;
    void clear();
    void getItems(QList<SchedulerItem>& items);
    bool isEmpty() const;

public slots:
    void store();

signals:
    void themeChanged();

private slots:
    void emitThemeChanged();

private:
    struct ItemDetails
    {
        QTime time;
        QString theme;
        QTimer timer;
    };

    ThemeScheduler();
    void loadConfig();
    void sort();
    bool enabled_;
    QList<ItemDetails*> items_;


};

#endif
