/*
 * This file is part of jSpeed.
 *
 * jSpeed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * jSpeed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with jSpeed.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <QtGui/QStandardItem>
#include <QtCore/QDebug>
#include "buttonselector.h"

ButtonSelector::ButtonSelector(QString const& text, QWidget* parent):
QMaemo5ValueButton(text, parent), selector_(0), model_(0)
{
    setValueLayout(QMaemo5ValueButton::ValueBesideText);
    selector_ = new QMaemo5ListPickSelector(this);
    connect(selector_, SIGNAL(selected(QString const&)), this, SLOT(onSelected(QString const&)));
    model_ = new QStandardItemModel(0, 1);
    selector_->setModel(model_);
    setPickSelector(selector_);
}

void ButtonSelector::addItem(QString const& text)
{
    addItem(text, QVariant(text));
}

void ButtonSelector::addItem(QString const& text, QVariant const& value)
{
    QStandardItem* item = new QStandardItem(text);
    item->setData(value, Qt::UserRole);
    item->setTextAlignment(Qt::AlignCenter);
    item->setEditable(false);
    model_->appendRow(item);

    if(selector_->currentIndex() < 0)
    {
        selector_->setCurrentIndex(0);
    }

}

void ButtonSelector::clear()
{
    model_->clear();
}

void ButtonSelector::setCurrentIndex(unsigned int index)
{
    selector_->setCurrentIndex(index);
}

int ButtonSelector::indexOfValue(QVariant const& value) const
{
    for(int i = 0; i < model_->rowCount(); i++)
    {
        QStandardItem* item = model_->item(i);

        if(item && item->data(Qt::UserRole) == value)
        {
            return i;
        }
    }

    return -1;
}

bool ButtonSelector::selectByValue(QVariant const& value)
{
    int index = indexOfValue(value);

    if(index < 0)
    {
        return false;
    }

    setCurrentIndex(index);

    return true;
}

int ButtonSelector::currentIndex() const
{
    return selector_->currentIndex();
}

QString ButtonSelector::text() const
{
    return selector_->currentValueText();
}

QVariant ButtonSelector::value() const
{
    int currentIndex = selector_->currentIndex();

    if(currentIndex < 0)
    {
        return QVariant("");
    }

    QStandardItem* item = model_->item(currentIndex);

    return item->data(Qt::UserRole);
}

bool ButtonSelector::changeItem(unsigned int index,
                                QString const& text)
{
    return changeItem(index, text, QVariant(text));
}

bool ButtonSelector::changeItem(unsigned int index,
                                QString const& text,
                                QVariant const& value)
{
    QStandardItem* item = model_->item(index);

    if(!item)
    {
        return false;
    }

    item->setText(text);
    item->setData(value, Qt::UserRole);

    return true;
}

bool ButtonSelector::removeItem(unsigned int index)
{
    return model_->removeRow(index);
}

int ButtonSelector::size() const
{
    return model_->rowCount();
}

void ButtonSelector::onSelected(QString const& text)
{
    emit selected();
}
