QT += maemo5 xml
TARGET = jspeed
TEMPLATE = app
CONFIG += mobility
MOBILITY += multimedia
SOURCES += src/main.cpp \ 
           src/mainwindow.cpp \
           src/mainwindowstack.cpp \
           src/location.cpp \
           src/graphicsscreen.cpp \
           src/abstractscreen.cpp \
           src/widgetscreen.cpp \
           src/toolbaritem.cpp \
           src/reader.cpp \
           src/zipreader.cpp \
           src/filereader.cpp \
           src/graphicselement.cpp \
           src/textelement.cpp \
           src/imageelement.cpp \
           src/rectangle.cpp \
           src/pointer.cpp \
           src/compass.cpp \
           src/odometer.cpp \
           src/themeloader.cpp \
           src/themescreen.cpp \
           src/settings.cpp \
           src/detailscreen.cpp \
           src/graphicsscene.cpp \
           src/mainmenu.cpp \
           src/buttonselector.cpp \
           src/themeselector.cpp \
           src/unitselector.cpp \
           src/effect.cpp \
           src/blureffect.cpp \
           src/opacityeffect.cpp \
           src/dropshadoweffect.cpp \
           src/flickereffect.cpp \
           src/poialerts.cpp \
           src/poireader.cpp \
           src/poiascreader.cpp \
           src/poisettings.cpp \
           src/speedalarmsettings.cpp \
           src/speedalarm.cpp \
           src/fileselector.cpp \
           src/themescheduler.cpp \
           src/themeschedulersettings.cpp \
           src/themepicker.cpp \
           src/mediaplayer.cpp \
           src/soundselector.cpp \
           src/buttonbox.cpp
HEADERS += src/mainwindow.h \
           src/mainwindowstack.h \
           src/location.h \
           src/graphicsscreen.h \
           src/abstractscreen.h \
           src/widgetscreen.h \
           src/toolbaritem.h \
           src/reader.h \
           src/zipreader.h \
           src/filereader.h \
           src/graphicselement.h \
           src/textelement.h \
           src/imageelement.h \
           src/rectangle.h \
           src/pointer.h \
           src/compass.h \
           src/odometer.h \
           src/themeloader.h \
           src/themescreen.h \
           src/settings.h \
           src/detailscreen.h \
           src/graphicsscene.h \
           src/mainmenu.h \
           src/buttonselector.h \
           src/themeselector.h \
           src/unitselector.h \
           src/effect.h \
           src/blureffect.h \
           src/opacityeffect.h \
           src/dropshadoweffect.h \
           src/flickereffect.h \
           src/poialerts.h \
           src/poireader.h \
           src/poiascreader.h \
           src/poisettings.h \
           src/speedalarmsettings.h \
           src/speedalarm.h \
           src/fileselector.h \
           src/themescheduler.h \
           src/themeschedulersettings.h \
           src/themepicker.h \
           src/mediaplayer.h \
           src/soundselector.h \
           src/buttonbox.h
RESOURCES = src/resources.qrc
CONFIG += link_pkgconfig
PKGCONFIG += liblocation libzip

unix {
  #VARIABLES
  isEmpty(PREFIX) {
    PREFIX = /usr
  }

  BINDIR = $$PREFIX/bin
  DATADIR =$$PREFIX/share
  APPDIR = /home/user/.jspeed

  DEFINES += DATADIR=\\\"$$DATADIR\\\" PKGDATADIR=\\\"$$PKGDATADIR\\\"

  #MAKE INSTALL

  INSTALLS += target desktop themes sounds icon26 icon48 icon64

  target.path =$$BINDIR

  desktop.path = $$DATADIR/applications/hildon
  desktop.files += src/data/$${TARGET}.desktop

  themes.path = $$APPDIR/themes
  themes.files += src/data/themes/white.jspeed \
                  src/data/themes/dark.jspeed

  sounds.path = $$APPDIR/sounds
  sounds.files += src/data/sounds/beep.mp3 \
                  src/data/sounds/arca.mp3 \
                  src/data/sounds/badumm.mp3 \
                  src/data/sounds/kind.mp3 \
                  src/data/sounds/sonar.mp3 \
                  src/data/sounds/spac.mp3 \
                  src/data/sounds/spring.mp3 \
                  src/data/sounds/steelyec.mp3 \
                  src/data/sounds/whoosh.mp3

  icon26.path = $$DATADIR/icons/hicolor/26x26/apps
  icon26.files += src/data/26x26/$${TARGET}.png

  icon48.path = $$DATADIR/icons/hicolor/48x48/apps
  icon48.files += src/data/48x48/$${TARGET}.png

  icon64.path = $$DATADIR/icons/hicolor/64x64/apps
  icon64.files += src/data/64x64/$${TARGET}.png
}
