/*
 * This file is part of jSpeed.
 *
 * jSpeed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * jSpeed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with jSpeed.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef POIREADER_H
#define POIREADER_H

#include <QtCore/QString>
#include <QtCore/QList>

class PoiReader
{
public:

    struct Poi
    {
        double latitude;
        double longitude;
        QString name;
    };

    enum Reader {ASCREADER, READER_COUNT};

    static PoiReader* getReader(QString const& filename);
    PoiReader();
    virtual bool read(QList<Poi>& pois) = 0;
    QString const& error();
    static QString getFormatPattern();
    static void getSupportedFormats(QList<QString>& formats);

protected:
    void setError(QString const& error);

private:
    QString error_;

};

#endif
