/*
 * This file is part of jSpeed.
 *
 * jSpeed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * jSpeed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with jSpeed.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <QtCore/QFile>
#include <QtCore/QString>
#include <QtCore/QByteArray>
#include <QtCore/QStringList>
#include <QtCore/QDebug>
#include <QtCore/QRegExp>
#include "poiascreader.h"

PoiAscReader::PoiAscReader(QString filename): PoiReader(), filename_(filename)
{
}

bool PoiAscReader::read(QList<Poi>& pois)
{
    pois.clear();

    QFile file(filename_);

    if(!file.open(QIODevice::ReadOnly))
    {
        setError("Unable to open file (check permissions)");
        return false;
    }

    while(!file.atEnd())
    {
        QString data(file.readLine());
        QStringList parts = data.split(",");

        if(parts.size() < 3)
        {
            continue;
        }

        QString longitude = parts.at(0).trimmed();
        QString latitude = parts.at(1).trimmed();

        bool ok;

        double doubleLatitude = latitude.toDouble(&ok);

        if(!ok)
        {
            continue;
        }

        double doubleLongitude = longitude.toDouble(&ok);

        if(!ok)
        {
            continue;
        }

        QString name = parts.at(2).trimmed();
        name.remove('"');

        Poi poi;
        poi.latitude = doubleLatitude;
        poi.longitude = doubleLongitude;
        poi.name = name;

        pois.push_back(poi);

    }

    if(pois.size() == 0)
    {
        setError("No valid poi data found from file");
        return false;
    }

    return true;
}
