/*
 * This file is part of jSpeed.
 *
 * jSpeed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * jSpeed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with jSpeed.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef TEXTELEMENT_H
#define TEXTELEMENT_H

#include "graphicselement.h"

class QString;
class QGraphicsItem;
class QGraphicsTextItem;
class Reader;
class GraphicsScene;

class TextElement : public GraphicsElement
{
public:
    enum Attribute {XPOS, YPOS, ZPOS, DATA, FORMAT, WIDTH, ALIGN, COLOR, SIZE, FONT, BOLD, ITALIC, UPPERCASE, LETTERSPACING, TIMEFORMAT, DATEFORMAT, ATTRIBUTE_COUNT};
    enum Field {TRIP, TOTAL, SPEED, MAXSPEED, AVGSPEED, UNIT, SPEEDUNIT, TIME, DATE, FIELD_COUNT};
    TextElement(Reader* reader);
    virtual bool setAttribute(QString const& name, QString const& value);
    virtual void addToScene(GraphicsScene* scene);
    virtual void update();
    virtual QGraphicsItem* getElement() const;

private:
    void updateHtml(QString data);
    void replaceSpecialFields(QString& value);
    void replaceValue(QString& value, Field field, QString const& replace);
    bool applyFont();
    QString formatString(double val);
    QGraphicsTextItem* element_;
    QString data_;
    QString format_;
    QString align_;
    QString timeFormat_;
    QString dateFormat_;
    int fontSize_;
    bool bold_;
    bool italic_;
    bool uppercase_;
    int letterSpacing_;
    QString fontFile_;
    QList<Field> specialFields_;
};

#endif
