/*
 * This file is part of Jenirok.
 *
 * Jenirok is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Jenirok is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Jenirok.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef SETTINGSDIALOG_H
#define SETTINGSDIALOG_H

#include <QtCore/QMap>
#include <QtCore/QString>
#include <QtCore/QVariant>
#include <QtGui/QDialog>
#include <QtGui/QWidget>
#include <QtGui/QLineEdit>
#include <QtGui/QCheckBox>
#include <QtGui/QTabWidget>
#include <QMaemo5ListPickSelector>
#include "source.h"

class SourceGuiConfig;
class ButtonSelector;
class ConnectionSelector;


class SettingsDialog : public QDialog
{
    Q_OBJECT

public:
    SettingsDialog(QWidget* parent = 0);

signals:
    void saved();

public slots:
    void saveSettings();
    void resetCache();

private slots:
    void onSourceSelected(unsigned int index, QString const& text, QVariant const& value);

private:
    static QList<Source::SourceDetails> sources_;
    SourceGuiConfig* sourceConfig_;
    QLineEdit* cacheInput_;
    ButtonSelector* languageSelector_;
    ButtonSelector* sourceSelector_;
    ButtonSelector* autostartSelector_;
    ConnectionSelector* connectionSelector_;
    QString currentSource_;
    QString selectedLanguage_;
    QTabWidget* tabs_;
};

#endif
