/*
 * This file is part of Jenirok.
 *
 * Jenirok is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Jenirok is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Jenirok.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <QtCore/QString>
#include <QtGui/QApplication>
#include "calllistener.h"
#include "settings.h"

int main(int argc, char *argv[])
{
    // If daemon was started on boot, the first parameter is set to "-boot"
    if(argc >= 2 && QString(argv[1]) == "-boot")
    {
        if(Settings::instance()->get("autostart") == "0")
        {
            // Autostart is disabled -> exit
            return 0;
        }
    }

    QApplication app(argc, argv);

    Settings::instance()->loadLanguage(app);

    CallListener listener;

    if(!listener.begin())
    {
        return 1;
    }

    return app.exec();

}
