/*
 * This file is part of Jenirok.
 *
 * Jenirok is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Jenirok is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Jenirok.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <QtCore/QDebug>
#include <QtGui/QHBoxLayout>
#include <QtGui/QVBoxLayout>
#include <QtGui/QLabel>
#include <QtGui/QDialogButtonBox>
#include <QMaemo5ValueButton>
#include "searchdialog.h"
#include "settings.h"

SearchDialog::SearchDialog(QWidget* parent): QDialog(parent),
numberInput_(0), locationInput_(0), selector_(0)
{
    setWindowTitle(tr("Search"));

    QHBoxLayout* numberLayout = new QHBoxLayout;
    QLabel* numberLabel = new QLabel(tr("Name/number"));
    numberInput_ = new QLineEdit;
    numberLayout->addWidget(numberLabel);
    numberLayout->addWidget(numberInput_);

    QHBoxLayout* locationLayout = new QHBoxLayout;
    QLabel* locationLabel = new QLabel(tr("Location"));
    locationInput_ = new QLineEdit;
    locationLayout->addWidget(locationLabel);
    locationLayout->addWidget(locationInput_);

    selector_ = new ButtonSelector(tr("Type"), this);
    loadSearchTypes();

    QVBoxLayout* leftLayout = new QVBoxLayout;
    leftLayout->addLayout(numberLayout);
    leftLayout->addLayout(locationLayout);
    leftLayout->addWidget(selector_);

    QDialogButtonBox* buttons = new QDialogButtonBox;
    buttons->setCenterButtons(false);
    QPushButton* submitButton = new QPushButton(tr("Search"));
    buttons->addButton(submitButton, QDialogButtonBox::AcceptRole);
    connect(submitButton, SIGNAL(pressed()), this, SLOT(searchPressed()));

    QHBoxLayout* mainLayout = new QHBoxLayout;
    mainLayout->addLayout(leftLayout, Qt::AlignLeft);
    mainLayout->addWidget(buttons);

    setLayout(mainLayout);
}

void SearchDialog::searchPressed()
{
    SearchDetails details;
    details.name = numberInput_->text();

    if(details.name.isEmpty())
    {
        numberInput_->setFocus();
        return;
    }

    details.location = locationInput_->text();

    int type = 0;

    if(selector_->isVisible())
    {
        type = selector_->value().toInt();
    }

    details.type = static_cast<Source::SearchType>(type);

    emit search(details);
    hide();
}

void SearchDialog::setVisible(bool visible)
{
    QDialog::setVisible(visible);

    if(visible)
    {
        numberInput_->setFocus();
    }
}

void SearchDialog::setSearchString(QString const& string)
{
    numberInput_->setText(string);
}

void SearchDialog::loadSearchTypes()
{
    selector_->clear();

    Source* source = Source::getSource(Source::stringToId(Settings::instance()->get("source")));

    QList<Source::SearchType> types;
    source->getSearchTypes(types);

    if(types.size() > 1)
    {
        for(int i = 0; i < types.size(); i++)
        {
            switch(types.at(i))
            {
            case Source::PERSONS:
                selector_->addItem(tr("Persons"), static_cast<int>(Source::PERSONS));
                break;
            case Source::YELLOW_PAGES:
                selector_->addItem(tr("Companies"), static_cast<int>(Source::YELLOW_PAGES));
                break;
            case Source::BOTH:
                break;
            }
        }

        if(!selector_->isVisible())
        {
            selector_->show();
        }
    }
    else
    {
        selector_->hide();
    }
}
