/*
 * This file is part of Jenirok.
 *
 * Jenirok is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Jenirok is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Jenirok.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <QtCore/QProcess>
#include "daemon.h"

namespace
{
    const QString DAEMON_NAME = "jenirokd";
    const QString INIT_DIR = "/etc/init.d";
}

bool Daemon::start()
{
    QProcess proc;
    proc.start(INIT_DIR + "/" + DAEMON_NAME, QStringList() << "start");

    proc.waitForStarted();
    proc.waitForFinished();

    if(proc.exitCode() != 0)
    {
        return false;
    }

    return true;
}

bool Daemon::stop()
{
    QProcess proc;
    proc.start(INIT_DIR + "/" + DAEMON_NAME, QStringList() << "stop");

    proc.waitForStarted();
    proc.waitForFinished();

    if(proc.exitCode() != 0)
    {
        return false;
    }

    return true;
}

bool Daemon::restart()
{
    stop();
    return start();
}

bool Daemon::isRunning()
{
    QProcess proc;

    proc.start("pgrep", QStringList() << "-n" << DAEMON_NAME);

    if(!proc.waitForStarted())
    {
        return false;
    }

    if(!proc.waitForFinished())
    {
        return false;
    }

    QString result = proc.readAll();

    return !result.isEmpty();
}

Daemon::Daemon()
{
}
