/*
 * This file is part of Jenirok.
 *
 * Jenirok is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Jenirok is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Jenirok.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef CACHE_H
#define CACHE_H

#include <QtCore/QList>
#include <QtCore/QPair>
#include "source.h"

class Cache
{

public:
    struct LogDetails
    {
        Source::Result result;
        int time;
        bool missed;
    };

    static int const LOG_MAX_SIZE = 80;

    static Cache& instance();
    int clear();
    bool findItem(QString const& number, Source::Result& result);
    bool addItem(Source::Result const& result);
    bool logItem(Source::Result const& result, bool missed, unsigned int time);
    void getLogItems(QList<LogDetails>& items, int limit);
    int clearLog();

private:
    Cache();
    static Cache* instance_;
};

#endif
