/*
 * This file is part of Jenirok.
 *
 * Jenirok is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Jenirok is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Jenirok.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef BUTTONSELECTOR_H
#define BUTTONSELECTOR_H

#include <QtCore/QVariant>
#include <QtCore/QString>
#include <QtGui/QStandardItemModel>
#include <QMaemo5ValueButton>
#include <QMaemo5ListPickSelector>

class ButtonSelector : public QMaemo5ValueButton
{
public:
    ButtonSelector(QString const& text, QWidget* parent = 0);
    void addItem(QString const& text);
    void addItem(QString const& text, QVariant const& value);
    void clear();
    void setCurrentIndex(int index);
    int currentIndex() const;
    QString text() const;
    QVariant value() const;

private:
    QMaemo5ListPickSelector* selector_;
    QStandardItemModel* model_;

};

#endif
