/*
 * This file is part of Jenirok.
 *
 * Jenirok is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Jenirok is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Jenirok.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <QtGui/QStandardItem>
#include "buttonselector.h"

ButtonSelector::ButtonSelector(QString const& text, QWidget* parent):
QMaemo5ValueButton(text, parent), selector_(0), model_(0)
{
    setValueLayout(QMaemo5ValueButton::ValueBesideText);
    selector_ = new QMaemo5ListPickSelector(this);
    model_ = new QStandardItemModel(0, 1);
    selector_->setModel(model_);
    setPickSelector(selector_);
}

void ButtonSelector::addItem(QString const& text)
{
    addItem(text, QVariant(text));
}

void ButtonSelector::addItem(QString const& text, QVariant const& value)
{
    QStandardItem* item = new QStandardItem(text);
    item->setData(value, Qt::UserRole);
    item->setTextAlignment(Qt::AlignCenter);
    item->setEditable(false);
    model_->appendRow(item);

    if(selector_->currentIndex() < 0)
    {
        selector_->setCurrentIndex(0);
    }
}

void ButtonSelector::clear()
{
    model_->clear();
}

void ButtonSelector::setCurrentIndex(int index)
{
    selector_->setCurrentIndex(index);
}

int ButtonSelector::currentIndex() const
{
    return selector_->currentIndex();
}

QString ButtonSelector::text() const
{
    return selector_->currentValueText();
}

QVariant ButtonSelector::value() const
{
    int currentIndex = selector_->currentIndex();

    if(currentIndex < 0)
    {
        return QVariant("");
    }

    QStandardItem* item = model_->item(currentIndex);

    return item->data(Qt::UserRole);
}
