/*
 * This file is part of Jenirok.
 *
 * Jenirok is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Jenirok is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Jenirok.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef DB_H
#define DB_H

#include <QtCore/QString>
#include <QtSql/QSqlDatabase>

class DB
{

public:
    static bool connect();
    static bool connected();
    static void disconnect();
    static void removeDatabase();
    QSqlDatabase& instance();

private:
    DB();
    static bool createTables();
    static QSqlDatabase db_;
    static bool initialized_;
};

#endif // DB_H

