/*
 * This file is part of Jenirok.
 *
 * Jenirok is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Jenirok is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Jenirok.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef SETTINGSDIALOG_H
#define SETTINGSDIALOG_H

#include <QtCore/QMap>
#include <QtCore/QString>
#include <QtGui/QDialog>
#include <QtGui/QWidget>
#include <QtGui/QLineEdit>
#include <QMaemo5ListPickSelector>
#include "eniro.h"
#include "buttonselector.h"

class SettingsDialog : public QDialog
{
    Q_OBJECT

public:
    SettingsDialog(QWidget* parent = 0);

public slots:
    void saveSettings();
    void setVisible(bool visible);
    void resetCache();

private:
    static QMap <Eniro::Site, Eniro::SiteDetails> sites_;
    QLineEdit* usernameInput_;
    QLineEdit* passwordInput_;
    QLineEdit* cacheInput_;
    ButtonSelector* siteSelector_;
    ButtonSelector* autostartSelector_;
    QString currentSite_;
    QString currentAutostart_;
};

#endif
