/*
 * This file is part of Jenirok.
 *
 * Jenirok is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Jenirok is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Jenirok.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef RESULTWINDOW_H
#define RESULTWINDOW_H

#include <QtCore/QVector>
#include <QtGui/QMainWindow>
#include <QtGui/QListWidget>
#include <QtGui/QListWidgetItem>
#include "searchdialog.h"
#include "eniro.h"
#include "connectionmanager.h"

class ResultWindow : public QMainWindow
{
    Q_OBJECT

public:
    ResultWindow(QWidget* parent = 0);
    ~ResultWindow();
    static const int REQUEST_TIMEOUT = 30000;

signals:
    void itemSelected(Eniro::Result const& result);

public slots:
    void search(SearchDialog::SearchDetails& details);

private slots:
    void resultAvailable(Eniro::Result const& result, Eniro::SearchDetails const& details);
    void requestFinished(QVector <Eniro::Result> const& results, Eniro::SearchDetails const& details, bool error);
    void itemClicked(QListWidgetItem* item);

private:
    Eniro* eniro_;
    QListWidget* list_;
    ConnectionManager* connectionManager_;

};

#endif
