/*
 * This file is part of Jenirok.
 *
 * Jenirok is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Jenirok is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Jenirok.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef CALLLISTENER_H
#define CALLLISTENER_H

#include <QtCore/QObject>
#include <QtCore/QString>
#include <QtGui/QLabel>
#include <QtDBus/QDBusConnection>
#include <QtDBus/QDBusObjectPath>
#include "informationbox.h"
#include "eniro.h"
#include "contactmanager.h"
#include "connectionmanager.h"

class CallListener: public QObject
{
    Q_OBJECT

public:
    CallListener();
    ~CallListener();
    void begin();
    void end();
    static const int REQUEST_TIMEOUT = 10000;
    static const int BANNER_DELAY = 400;
    static const int NUMBER_OF_RETRIES = 3;

private slots:
    void requestFinished(QVector <Eniro::Result> const& results, Eniro::SearchDetails const& details, bool error);
    void incomingCall(QDBusObjectPath path, QString numbe);
    void callTerminate();
    void showTimedMessage();

private:
    Q_DISABLE_COPY(CallListener);

    void search(Eniro::SearchDetails const& details);
    void showResult(QString const& text);
    void showDelayedResult(QString const& text, int delay);
    QString createResult(QString const& name, QString const& street, QString const& city);
    QString timedMessage_;
    Eniro* eniro_;
    ContactManager* contactManager_;
    ConnectionManager* connectionManager_;
    bool closeConnection_;
    InformationBox* box_;
    QLabel* label_;
    static QDBusConnection systemBus_;
    int retries_;
    QString currentSearch_;
};

#endif // CALLLISTENER_H
