/*
 * This file is part of Jenirok.
 *
 * Jenirok is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Jenirok is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Jenirok.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <QtSql/QSqlQuery>
#include <QtCore/QVariant>
#include "settings.h"
#include "db.h"

Settings* Settings::instance_ = 0;

Settings* Settings::instance()
{
    if(!instance_)
    {
        instance_ = new Settings;
    }

    return instance_;
}

bool Settings::set(QString const& name, QString const& value)
{
    bool connected = DB::connected();

    if(!connected)
    {
        if(!DB::connect())
        {
            return false;
        }
    }

    QSqlQuery deleteQuery;
    deleteQuery.prepare("DELETE FROM settings WHERE name = :name");
    deleteQuery.bindValue(":name", QVariant(name));
    deleteQuery.exec();

    QSqlQuery query;
    query.prepare("INSERT INTO settings(name, value) VALUES(:name, :value)");
    query.bindValue(":name", QVariant(name));
    query.bindValue(":value", QVariant(value));

    bool returnValue = query.exec();

    if(!connected)
    {
        DB::disconnect();
    }

    return returnValue;
}

QString Settings::get(QString const& name)
{
    QString result = "";

    bool connected = DB::connected();

    if(!connected)
    {
        if(!DB::connect())
        {
            return result;
        }
    }

    QSqlQuery query;

    query.prepare("SELECT value FROM settings WHERE name = :name");
    query.bindValue(":name", name);

    if(query.exec() && query.next())
    {
        result = query.value(0).toString();
    }
    else
    {
        result = getDefaultValue(name);
    }

    if(!connected)
    {
        DB::disconnect();
    }

    return result;

}

QString Settings::getDefaultValue(QString const& name)
{
    static bool defaultValuesLoaded = false;
    static QMap <QString, QString> defaultValues;

    if(!defaultValuesLoaded)
    {
        defaultValues["autostart"] = "1";
        defaultValues["eniro_site"] = tr("fi");
        defaultValues["cache_size"] = "200";
        defaultValuesLoaded = true;
    }

    QMap<QString, QString>::const_iterator it = defaultValues.find(name);

    if(it != defaultValues.end())
    {
        return it.value();
    }

    return "";

}

bool Settings::reset()
{
    bool connected = DB::connected();

    if(!connected)
    {
        if(!DB::connect())
        {
            return false;
        }
    }

    QSqlQuery query;

    bool ret = query.exec("DELETE FROM settings");

    if(!connected)
    {
        DB::disconnect();
    }

    return ret;
}

Settings::Settings()
{
}
