/*
 * This file is part of Jenirok.
 *
 * Jenirok is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Jenirok is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Jenirok.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef CONNECTIONMANAGER_H
#define CONNECTIONMANAGER_H

#include <QtCore/QObject>
#include <QtCore/QTimerEvent>
#include <QtCore/QString>
#include <QtCore/QByteArray>
#include <QtCore/QList>
#include <QtDBus/QDBusInterface>
#include <QtDBus/QDBusMessage>

class ConnectionManager : public QObject
{
    Q_OBJECT

public:

    struct Connection
    {
        QString serviceType;
        unsigned int serviceAttributes;
        QString serviceID;
        QString networkName;
        QString networkType;
        unsigned int networkAttributes;
        QByteArray networkID;
    };

    ConnectionManager(QObject* parent = 0);
    ~ConnectionManager();
    void setBlocking(bool value);
    bool connect();
    bool connect(Connection const& connection);
    bool disconnect(bool force = false);
    bool isConnected();
    bool scanConnections(QList<Connection>& connections);
    static unsigned int const TIMEOUT = 25000;

signals:
    void connectReply(bool connected);
    void isConnectedReply(bool connected);
    void newConnection(ConnectionManager::Connection const& connection);
    void scanReady();

protected:
    virtual void timerEvent(QTimerEvent* event);

private slots:
    void stateChange(const QDBusMessage& rep);
    void connectionChange(const QDBusMessage& rep);
    void scanResult(const QDBusMessage& rep);

private:
    bool waitSignal(bool* ready);
    bool blocking_;
    bool stateReady_;
    bool connectionReady_;
    bool scanReady_;
    bool connected_;
    bool timeout_;
    int numberOfConnections_;
    int scannedConnections_;
    int timer_;
    QList<Connection>* connections_;
    QDBusInterface *icd2interface_;
};

#endif
